package org.zeroturnaround.jrebel.liferay.util;

import java.io.IOException;
import java.io.InputStream;

public class ClassLoaderResourceInputStream extends InputStream {
  private final InputStream inputStream;
  public final ClassLoader classLoader;
  public final String resourceName;

  public int read() throws IOException {
    return inputStream.read();
  }

  public ClassLoaderResourceInputStream(InputStream inputStream, ClassLoader classLoader, String resourceName) {
    this.inputStream = inputStream;
    this.classLoader = classLoader;
    this.resourceName = resourceName;
  }

  public void mark(int readlimit) {
    inputStream.mark(readlimit);
  }

  public int available() throws IOException {
    return inputStream.available();
  }

  public boolean markSupported() {
    return inputStream.markSupported();
  }

  public void close() throws IOException {
    inputStream.close();
  }

  public int read(byte[] b, int off, int len) throws IOException {
    return inputStream.read(b, off, len);
  }

  public void reset() throws IOException {
    inputStream.reset();
  }

  public int read(byte[] b) throws IOException {
    return inputStream.read(b);
  }

  public long skip(long n) throws IOException {
    return inputStream.skip(n);
  }
}
