package org.zeroturnaround.jrebel.liferay.util;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.RebelServletContext;
import org.zeroturnaround.javarebel.RebelSource;
import org.zeroturnaround.javarebel.ServletIntegrationFactory;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.ReflectionUtil;
import org.zeroturnaround.jrebel.liferay.JrDelegateInvocationHandler;
import org.zeroturnaround.jrebel.liferay.LiferayPlugin;

public class LiferayHookUtil {

  private static final Logger log = LoggerFactory.getLogger(LiferayPlugin.PRODUCT_PREFIX);
  private static final Map<RebelServletContext, RebelSource[]> rebelSourcesByContexts = Collections.synchronizedMap(new WeakHashMap<RebelServletContext, RebelSource[]>());

  public static void registerHook(RebelServletContext baseContext, RebelServletContext hookContext, String customJspsPrefix) {
    log.info("Attaching hook context {} to base context {} with custom jsps folder '{}'", new Object[] { baseContext, hookContext, customJspsPrefix });

    ServletIntegrationFactory.getInstance().registerAdditionalWebResourcesWithPrefix(baseContext, hookContext, customJspsPrefix);
    ServletIntegrationFactory.getInstance().registerAdditionalWebResources(baseContext, hookContext, customJspsPrefix);
  }

  public static void unregisterHook(RebelServletContext baseContext, RebelServletContext hookContext) {
    log.info("Dettaching hook context {} from base context {}", baseContext, hookContext);
    ServletIntegrationFactory.getInstance().unregisterAdditionalWebResources(baseContext, hookContext);
  }

  public static long getFileLastModified(String path, RebelServletContext sc) {
    RebelSource[] rs = rebelSourcesByContexts.get(sc);
    if (rs == null) {
      rs = ServletIntegrationFactory.getInstance().getRebelSources(sc);
      if (rs == null) {
        rs = new RebelSource[0];
      }
      rebelSourcesByContexts.put(sc, rs);
      log.info("Cached {} RebelSources for {} it real path as {} from the original {}", rs.length, MiscUtil.identityToString(sc), sc.getRealPath(""), ServletIntegrationFactory.getInstance().getTransparentRealPath(sc, ""));
    }
    for (RebelSource r : rs) {
      if (r.acceptPath(path)) {
        File f = new File(r.getDir(), path);
        if (f.exists()) {
          log.info("Cache servlet last modify for {} from {}", f, MiscUtil.identityToString(sc));
          return f.lastModified();
        }
      }
    }
    return -1;
  }

  public static RebelServletContext unwrap(RebelServletContext sc) {
    if (sc != null) {
      Field realScField = ReflectionUtil.getDeclaredField(sc.getClass(), "_default");
      if (realScField != null) {
        try {
          Object realSc = realScField.get(sc);
          if (realSc instanceof RebelServletContext) {
            return (RebelServletContext) realSc;
          }
        }
        catch (Exception e) {
          log.warn("Cannot get the value of {}._default: {}", sc.getClass(), e);
        }
      } else if (Proxy.isProxyClass(sc.getClass())) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(sc);

        if (invocationHandler instanceof JrDelegateInvocationHandler) {
          Object defaultObject = ((JrDelegateInvocationHandler) invocationHandler).jrGetDefault();
          if (defaultObject instanceof RebelServletContext) {
            return (RebelServletContext) defaultObject;
          }
        } else {
          log.warn("Cannot get wrapped object of {} proxy. InvocationHandler handler type {}", sc.getClass(), invocationHandler.getClass());
        }
      }
    }
    return sc;
  }
}
