package org.zeroturnaround.jrebel.liferay.util;

import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;

/**
 * Patches script from: "com/liferay/portal/servlet/filters/dynamiccss/main.rb"
 */
public class RubyScriptPatcher {

  private static final Logger log = LoggerFactory.getLogger("Liferay");

  public static String patch(final String script) {
    if (script == null) {
      return null;
    }

    String patched = script.replace("[$cssThemePath]", "$cssThemePaths");
    patched = patched.replace("if $cssThemePath", "if $cssThemePaths");

    if (patched.contains("rescue")) {
      // 6.1
      patched = patched.replace(
          "rescue",
          "engine.dependencies.map { |e| $dependencies.add(e.options[:filename]) }\nrescue");
    } else {
      // 6.2 ga4
      patched = patched.replace(
          "engine.render",
          "engine.render\nengine.dependencies.map { |e| $dependencies.add(e.options[:filename]) }");
    }

    log.debug("Patched SASS compilation script: {}", patched.replace("\n", " "));
    return patched;
  }

}
