package org.zeroturnaround.jrebel.liferay.util;

import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.StatisticsCollectorFactory;
import org.zeroturnaround.jrebel.liferay.LiferayPlugin;

import com.liferay.portal.kernel.util.ReleaseInfo;

public class VersionTracking {

  private static final Logger log = LoggerFactory.getInstance().productPrefix(LiferayPlugin.PRODUCT_PREFIX);

  private static final String PLUGIN_NAME = "liferay";

  public static void reportLiferayVersion() {
    String version = ReleaseInfo.getVersion();
    StatisticsCollectorFactory.getInstance().addFrameworkStatisticsItem(PLUGIN_NAME, version);
    log.info("Detected version {}", version);
  }
}
