/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.liferay;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.plugin.PluginPackage;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.RequestIntegrationFactory;
import org.zeroturnaround.javarebel.RequestListener;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.generic.RequestListenerAdapter;
import org.zeroturnaround.javarebel.integration.monitor.MonitoredResource;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.MonitorUtil;
import org.zeroturnaround.javarebel.integration.util.ReRunThrottler;
import org.zeroturnaround.javarebel.integration.util.ReflectionUtil;
import org.zeroturnaround.javarebel.integration.util.RequestListenerUtil;
import org.zeroturnaround.javarebel.integration.util.ResourceUtil;

public class LiferayReloader {
    public static final String MONITOR = "LiferayPluginReload";
    private static final Logger log = LoggerFactory.getInstance().productPrefix("Liferay");
    private static final boolean ENABLED = ConfigurationFactory.getInstance().getBoolean("rebel.liferay.monitor", true);
    private final HotDeployListener listener;
    private final WeakReference<ClassLoader> contextClassLoader;
    private final boolean isWebAppClassloader;
    private final WeakReference<ServletContext> servletContext;
    private final String servletContextName;
    private final PluginPackage pluginPackage;
    private final List<MonitoredResource> resources = Collections.synchronizedList(new ArrayList());
    private final RequestListener registeredListener;
    private final RequestListenerAdapter rl = new RequestListenerAdapter(0){
        private final ReRunThrottler throttler;
        {
            this.throttler = new ReRunThrottler();
        }

        public void beforeRequest() throws Exception {
            if (this.throttler.shouldThrottle()) {
                return;
            }
            StopWatch sw = log.createStopWatch("LiferayReloader#beforeRequest");
            try {
                LiferayReloader.this.beforeRequest();
            }
            finally {
                sw.stop();
            }
        }
    };

    public static void registerResource(Map<ServletContext, LiferayReloader> reloaders, HotDeployListener listener, HotDeployEvent event, String resource) {
        URL url = event.getContextClassLoader().getResource(resource + ".properties");
        LiferayReloader.registerResource(reloaders, listener, event, url);
    }

    public static void registerResource(Map<ServletContext, LiferayReloader> reloaders, HotDeployListener listener, HotDeployEvent event, URL url) {
        if (!ENABLED || url == null) {
            return;
        }
        ServletContext servletContext = event.getServletContext();
        try {
            LiferayReloader reloader = reloaders.get(servletContext);
            if (reloader == null) {
                reloader = new LiferayReloader(listener, event);
                reloaders.put(servletContext, reloader);
            }
            reloader.addResource(url);
        }
        catch (Exception e) {
            log.error("registerResource failed on " + listener.getClass() + " for " + MiscUtil.identityToString((Object)servletContext), (Throwable)e);
        }
    }

    private LiferayReloader(HotDeployListener listener, HotDeployEvent event) {
        this.listener = listener;
        this.contextClassLoader = new WeakReference<ClassLoader>(event.getContextClassLoader());
        this.isWebAppClassloader = this.isWebAppClassLoader(event.getContextClassLoader());
        this.servletContext = new WeakReference<ServletContext>(event.getServletContext());
        this.servletContextName = event.getServletContextName();
        this.pluginPackage = event.getPluginPackage();
        if (this.servletContextName == null) {
            throw new IllegalArgumentException("servletContextName");
        }
        this.registeredListener = RequestListenerUtil.bindContextClassLoader((RequestListener)this.rl);
        RequestIntegrationFactory.getInstance().addRequestListener(this.registeredListener);
        log.info("Registered reloader on {} ({}), listener {}", new Object[]{MiscUtil.identityToString((Object)event.getServletContext()), this.servletContextName, listener.getClass().getName()});
    }

    void addResource(URL url) {
        this.resources.add(new MonitoredResource(ResourceUtil.asResource((URL)url)));
        log.info("Listening '" + url + "' for changes on " + this.listener.getClass() + " in " + this.servletContextName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beforeRequest() {
        ClassLoader contextClassLoader = (ClassLoader)this.contextClassLoader.get();
        ServletContext servletContext = (ServletContext)this.servletContext.get();
        if (servletContext == null || contextClassLoader == null) {
            RequestIntegrationFactory.getInstance().removeRequestListener(this.registeredListener);
            return;
        }
        if (this.isStopped(contextClassLoader)) {
            log.trace("Removing listener from old instance of " + this.servletContextName + ", cl stopped " + MiscUtil.identityToString((Object)contextClassLoader));
            RequestIntegrationFactory.getInstance().removeRequestListener(this.registeredListener);
            return;
        }
        log.trace("Checking {} resources in {} {}", new Object[]{this.resources.size(), this.servletContextName, this.listener.getClass()});
        if (this.hasModifiedResources()) {
            StopWatch swrd = log.createStopWatch("LiferayReloader#redeploy");
            MonitorUtil.enter((String)(MONITOR + this.servletContextName));
            try {
                log.info("Starting redeploy of " + this.servletContextName);
                this.redeploy(contextClassLoader, servletContext);
            }
            finally {
                MonitorUtil.exit((String)(MONITOR + this.servletContextName));
                swrd.stop();
            }
        }
    }

    private boolean isStopped(ClassLoader contextClassLoader) {
        if (!this.isWebAppClassloader) {
            return false;
        }
        try {
            return (Boolean)ReflectionUtil.invoke((Object)contextClassLoader, (String)"isStarted") == false;
        }
        catch (Exception e) {
            log.trace("Failed to check isStarted() on " + MiscUtil.identityToString((Object)contextClassLoader), (Throwable)e);
            return false;
        }
    }

    private boolean isWebAppClassLoader(ClassLoader cl) {
        return "org.apache.catalina.loader.WebappClassLoader".equals(cl.getClass().getName());
    }

    private boolean hasModifiedResources() {
        boolean modified = false;
        for (MonitoredResource res : new ArrayList<MonitoredResource>(this.resources)) {
            try {
                if (!res.modified()) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Modified: " + res);
                }
                modified = true;
            }
            catch (Exception e) {
                if (log.isEnabled()) {
                    log.log("Resource has been removed: " + res);
                }
                this.resources.remove(res);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redeploy(ClassLoader contextClassLoader, ServletContext servletContext) {
        ArrayList<MonitoredResource> resourceOld = new ArrayList<MonitoredResource>(this.resources);
        try {
            this.resources.clear();
            HotDeployEvent event = new HotDeployEvent(servletContext, contextClassLoader);
            event.setPluginPackage(this.pluginPackage);
            try {
                LiferayReloader.markContextForReload(servletContext.getServletContextName());
                this.listener.invokeUndeploy(event);
                this.listener.invokeDeploy(event);
            }
            finally {
                LiferayReloader.markContextReloaded(servletContext.getServletContextName());
            }
        }
        catch (IllegalStateException e) {
            RequestIntegrationFactory.getInstance().removeRequestListener(this.registeredListener);
            log.info("Redeploy aborted on " + this.listener.getClass() + " for " + MiscUtil.identityToString((Object)servletContext));
        }
        catch (HotDeployException e) {
            log.error("Reloading failed on " + this.listener.getClass() + " for " + MiscUtil.identityToString((Object)servletContext), (Throwable)e);
            this.resources.clear();
            this.resources.addAll(resourceOld);
        }
    }

    private static void markContextForReload(String contextPath) {
        try {
            Class<?> clazz = LiferayReloader.class.getClassLoader().loadClass("org.zeroturnaround.jrebel.liferay.util.LiferayDeployStatus");
            ReflectionUtil.invokeStaticByArgs(clazz, (String)"setReloading", (Object[])new Object[]{contextPath});
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void markContextReloaded(String contextPath) {
        try {
            Class<?> clazz = LiferayReloader.class.getClassLoader().loadClass("org.zeroturnaround.jrebel.liferay.util.LiferayDeployStatus");
            ReflectionUtil.invokeStaticByArgs(clazz, (String)"setContextPortalEnvInitialized", (Object[])new Object[]{contextPath});
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

