/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.bundled.javassist.expr.NewExpr;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.RebelServletContext;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;

public class MinifierFilterCBP
extends CacheAwareJavassistClassBytecodeProcessor {
    private static final String JR_LOGGER = "LoggerFactory.getLogger(\"Liferay\")";
    public static final String READ_METHOD_WITH_STRING_SIGNATURE = "(Ljava/lang/String;)Ljava/lang/String;";

    public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
        cp.importPackage("java.io");
        cp.importPackage("org.zeroturnaround.javarebel");
        CtMethod m = ctClass.getDeclaredMethod("getMinifiedBundleContent");
        ctClass.addMethod(CtNewMethod.make((String)"public String jrFormat(String fullprefix, String prefix, String original) {  try {    if (prefix.endsWith(\"/\")) {      original = prefix + original.substring(fullprefix.length() + 1);    } else {      original = prefix + original.substring(fullprefix.length());    }  } catch (StringIndexOutOfBoundsException e) {    LoggerFactory.getLogger(\"Liferay\").info(\"Problem substringing '{}' with '{}'\",original, fullprefix);  }  return original;}", (CtClass)ctClass));
        m.addLocalVariable("jrFixedPrefix", cp.get(String.class.getName()));
        m.addLocalVariable("jrServletContext", cp.get(RebelServletContext.class.getName()));
        m.addLocalVariable("jrOriginalPath", cp.get(String.class.getName()));
        m.addLocalVariable("jrCacheFileName", cp.get(String.class.getName()));
        m.insertBefore("{  jrCacheFileName = \"\"; }");
        m.instrument(new ExprEditor(){

            public void edit(NewExpr e) throws CannotCompileException {
                LoggerFactory.getLogger((String)"Liferay").info("newxp test: " + e.getClassName() + " " + e.getLineNumber());
                if ("java.io.File".equals(e.getClassName())) {
                    e.replace("$_ = $proceed($$); if ((jrCacheFileName.length() == 0 || !$1.endsWith(jrCacheFileName)) && !$_.exists()) {  $_ = new File(jrServletContext.getRealPath(jrFormat(jrFixedPrefix, jrOriginalPath, $1)));}");
                }
            }

            public void edit(MethodCall m) throws CannotCompileException {
                LoggerFactory.getLogger((String)"Liferay").info("Method test: " + m.getMethodName() + " " + m.getClassName() + " " + m.getLineNumber());
                if ("getRealPath".equals(m.getMethodName())) {
                    m.replace("$_ = $proceed($$);jrFixedPrefix = $_;jrServletContext = (RebelServletContext) $1;jrOriginalPath = $2;");
                } else if ("read".equals(m.getMethodName()) && MinifierFilterCBP.READ_METHOD_WITH_STRING_SIGNATURE.equals(m.getSignature())) {
                    m.replace("File f = new File($1);if (!f.exists()) {  $1 = jrServletContext.getRealPath(jrFormat(jrFixedPrefix, jrOriginalPath, $1));}$_ = $proceed($$);");
                } else if ("getCacheFileName".equals(m.getMethodName()) || "toString".equals(m.getMethodName())) {
                    m.replace("$_ = $proceed($$);jrCacheFileName = $_;");
                }
            }
        });
    }
}

