/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.liferay.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.RebelServletContext;
import org.zeroturnaround.javarebel.RebelSource;
import org.zeroturnaround.javarebel.ResourceIntegrationFactory;
import org.zeroturnaround.javarebel.ServletIntegrationFactory;

public class ThemeCssReloader {
    private static final Logger log = LoggerFactory.getLogger((String)"Liferay");
    private static final boolean enabled = ResourceIntegrationFactory.getInstance().isEnabled();
    private static final Map<String, ThemeCssReloader> monitorsByContexts = Collections.synchronizedMap(new HashMap());
    private final Map<String, Long> generationTimestamps = Collections.synchronizedMap(new HashMap());
    private final Map<String, Set<String>> cssDependencies = Collections.synchronizedMap(new HashMap());
    private final WeakReference<RebelServletContext> context;
    private final String contextPath;
    private final List<String> roots;

    private ThemeCssReloader(RebelServletContext context, String contextPath, List<String> roots) {
        this.context = new WeakReference<RebelServletContext>(context);
        this.contextPath = contextPath;
        this.roots = roots;
    }

    public static ThemeCssReloader addToServletContext(RebelServletContext context, String contextPath) {
        ThemeCssReloader themeFilesMonitor = ThemeCssReloader.getInstance(contextPath);
        if (themeFilesMonitor != null) {
            if (context.equals(themeFilesMonitor.context.get())) {
                return themeFilesMonitor;
            }
            log.info("Application has been redeploy on: {}", (Object)contextPath);
        }
        themeFilesMonitor = new ThemeCssReloader(context, contextPath, ThemeCssReloader.findWebRoots(context));
        if (contextPath != null && contextPath.length() > 0) {
            monitorsByContexts.put(contextPath, themeFilesMonitor);
        }
        log.info("Watching roots: {} for {}", themeFilesMonitor.roots, (Object)themeFilesMonitor.contextPath);
        return themeFilesMonitor;
    }

    private static List<String> findWebRoots(RebelServletContext context) {
        String transparentPath;
        ArrayList<String> roots = new ArrayList<String>();
        RebelSource[] rebelSources = ServletIntegrationFactory.getInstance().getRebelSources(context);
        if (rebelSources != null) {
            for (RebelSource rebelSource : rebelSources) {
                File dir = rebelSource.getFile();
                if (!dir.isDirectory()) continue;
                roots.add(dir.getAbsolutePath());
            }
        }
        if ((transparentPath = ServletIntegrationFactory.getInstance().getTransparentRealPath(context, "")) != null) {
            roots.add(transparentPath);
        }
        return roots;
    }

    public static boolean isContextMonitored(String contextPath, String servletPath) {
        return ThemeCssReloader.getInstance(contextPath) != null && servletPath.toLowerCase().endsWith(".css") && servletPath.toLowerCase().startsWith("/css/");
    }

    public static String[] remapThemePath(RebelServletContext rebelContext, Map<String, Object> inputObjects) {
        File original;
        String cssThemePath = (String)inputObjects.get("cssThemePath");
        ArrayList<String> result = new ArrayList<String>();
        for (String root : ThemeCssReloader.findWebRoots(rebelContext)) {
            File candidate = new File(root, "/css");
            if (!candidate.exists()) continue;
            result.add(candidate.getAbsolutePath());
        }
        String transparent = ServletIntegrationFactory.getInstance().getTransparentRealPath(rebelContext, "");
        String rebel = rebelContext.getRealPath("");
        if (rebel != null && transparent != null && cssThemePath.startsWith(rebel) && (original = new File(transparent, cssThemePath.substring(rebel.length()))).exists()) {
            result.add(original.getAbsolutePath());
        }
        if (result.isEmpty()) {
            result.add(cssThemePath);
        } else {
            log.info("Changed SASS eval path to: {}", result);
        }
        return result.toArray(new String[result.size()]);
    }

    public static void updateDependencies(String contextPath, String resourcePath, Set<String> dependencies) {
        ThemeCssReloader instance = ThemeCssReloader.getInstance(contextPath);
        if (instance != null) {
            instance.updatePathDependencies(resourcePath, dependencies);
        }
    }

    private void updatePathDependencies(String resourcePath, Set<String> dependencies) {
        resourcePath = ThemeCssReloader.sanitizePath(resourcePath);
        HashSet<String> relativeDependencies = new HashSet<String>();
        for (String dependency : dependencies) {
            for (String root : this.roots) {
                if (!dependency.startsWith(root)) continue;
                relativeDependencies.add(dependency.substring(root.length()));
            }
        }
        log.trace("Dependencies for {}{} are {}", new Object[]{this.contextPath, resourcePath, relativeDependencies});
        this.cssDependencies.put(resourcePath, relativeDependencies);
    }

    public static boolean isDirty(String contextPath, String requestPath, Class<?> filterClazz) {
        ThemeCssReloader instance = ThemeCssReloader.getInstance(contextPath);
        return instance != null && instance.isDirty(requestPath, filterClazz);
    }

    public synchronized boolean isDirty(String requestPath, Class<?> filterClazz) {
        Long reloadTimestamp = this.generationTimestamps.get(requestPath = ThemeCssReloader.sanitizePath(requestPath));
        boolean dirty = reloadTimestamp == null || reloadTimestamp < this.getLastChangeTime(requestPath);
        String prefix = filterClazz == null ? "" : "Filter class \"" + filterClazz.getSimpleName() + "\": ";
        log.debug("{}Resource {}{} is {}", new Object[]{prefix, this.contextPath, requestPath, dirty ? "dirty" : "clean"});
        return !enabled || dirty;
    }

    private long getLastChangeTime(String requestPath) {
        RebelServletContext context = (RebelServletContext)this.context.get();
        if (context == null) {
            throw new IllegalStateException("context");
        }
        long latest = this.getLastModified(context, requestPath);
        Set<String> dependencies = this.cssDependencies.get(requestPath);
        if (dependencies != null) {
            for (String dependency : dependencies) {
                latest = Math.max(latest, this.getLastModified(context, dependency));
            }
        }
        return latest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long getLastModified(RebelServletContext context, String resourcePath) {
        long l;
        String id;
        InputStream closeReference;
        block11: {
            closeReference = null;
            id = null;
            URL resource = context.getResource(resourcePath);
            log.trace("Got resource {}", (Object)resource);
            URLConnection urlConnection = resource.openConnection();
            id = urlConnection.toString();
            log.trace("Opened connection to {}", (Object)id);
            long lastModified = urlConnection.getLastModified();
            closeReference = urlConnection.getInputStream();
            log.trace("Got last modification date of {}", (Object)lastModified);
            l = lastModified;
            if (closeReference == null) break block11;
            try {
                closeReference.close();
                log.trace("Closed connection to {}", (Object)id);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        return l;
        catch (Exception e) {
            long l2;
            block12: {
                try {
                    log.warnEcho("failed to check timestamp of '" + resourcePath + "': " + e.getMessage());
                    log.error((Throwable)e);
                    l2 = 0L;
                    if (closeReference == null) break block12;
                }
                catch (Throwable throwable) {
                    if (closeReference != null) {
                        try {
                            closeReference.close();
                            log.trace("Closed connection to {}", id);
                        }
                        catch (IOException e2) {
                            log.error((Throwable)e2);
                        }
                    }
                    throw throwable;
                }
                try {
                    closeReference.close();
                    log.trace("Closed connection to {}", (Object)id);
                }
                catch (IOException e3) {
                    log.error((Throwable)e3);
                }
            }
            return l2;
        }
    }

    public static void reset(String contextPath, String resourcePath) {
        ThemeCssReloader instance = ThemeCssReloader.getInstance(contextPath);
        if (instance != null) {
            instance.reset(resourcePath);
        }
    }

    public synchronized void reset(String requestPath) {
        requestPath = ThemeCssReloader.sanitizePath(requestPath);
        this.generationTimestamps.put(requestPath, System.currentTimeMillis());
        log.debug("Resetting resource {}{}", (Object)this.contextPath, (Object)requestPath);
    }

    private static String sanitizePath(String path) {
        return path.trim().replace("//", "/");
    }

    private static ThemeCssReloader getInstance(String contextPath) {
        return monitorsByContexts.get(contextPath);
    }
}

