/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.LiferayReloader;

public class HotDeployListenerCBP
extends CacheAwareJavassistClassBytecodeProcessor {
    private static final Logger log = LoggerFactory.getInstance().productPrefix("Liferay");

    public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
        this.processResources(cp, cl, ctClass);
    }

    public void processResources(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
        cp.importPackage("java.util");
        cp.importPackage("java.net");
        cp.importPackage("org.zeroturnaround.javarebel.integration.util");
        ctClass.addField(CtField.make((String)"private final Map __reloader = Collections.synchronizedMap(new WeakIdentityHashMap());", (CtClass)ctClass));
        CtMethod m = ctClass.getDeclaredMethod("doInvokeDeploy");
        CtClass param = cp.getCtClass(HotDeployEvent.class.getName());
        m.addLocalVariable("__event", param);
        m.insertBefore("{  __event = $1;}");
        m.instrument(new ExprEditor(){

            public void edit(MethodCall m) throws CannotCompileException {
                if ("getResource".equals(m.getMethodName())) {
                    m.replace("{  $_ = $proceed($$);  " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, $_);}");
                } else if ("getConfiguration".equals(m.getMethodName())) {
                    m.replace("{  $_ = $proceed($$);  " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, $2);}");
                } else if ("create".equals(m.getMethodName())) {
                    m.replace("{  $_ = $proceed($$);  if ($_ != null && $1.getFriendlyURLRoutes() != null) {     String xmlFile = $1.getFriendlyURLRoutes();    " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, __event.getContextClassLoader().getResource($1.getFriendlyURLRoutes()));  } }");
                } else if ("getResourceAsStream".equals(m.getMethodName())) {
                    m.replace("{  $_ = $proceed($$);  URL u = $0.getResource($1);  " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, u);}");
                }
            }
        });
        CtMethod undeploy = ctClass.getDeclaredMethod("doInvokeUndeploy");
        undeploy.insertBefore("__reloader.remove($1.getServletContext());");
        try {
            ctClass.getDeclaredMethod("processPortletProperties");
            m.insertAfter("{  " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, \"portlet\");}");
        }
        catch (Exception e) {
            log.trace("processPortletProperties: {}", (Object)e.getMessage());
        }
        try {
            final CtMethod initLanguageProperties = ctClass.getDeclaredMethod("initLanguageProperties");
            initLanguageProperties.addParameter(param);
            initLanguageProperties.addLocalVariable("__event", param);
            initLanguageProperties.insertBefore("__event = $" + initLanguageProperties.getParameterTypes().length + ";");
            initLanguageProperties.instrument(new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if ("openStream".equals(m.getMethodName())) {
                        m.replace("{  $_ = $proceed($$);  " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, $0);}");
                    }
                }
            });
            m.instrument(new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (initLanguageProperties.getName().equals(m.getMethodName())) {
                        m.replace("{$_ = $proceed($$, __event);}");
                    }
                }
            });
        }
        catch (NotFoundException e) {
            log.trace("initLanguageProperties: {}", (Object)e.getMessage());
        }
    }
}

