/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

/**
 * A factory for {@link Logger} that resolves a suitable implementation.
 * 
 * As a rule plugin developers should use {@link #getLogger(String)} method  to get logger instance. 
 * This will ensure that messages logged by the plugin are distinguishable from other log messages.
 *  
 * Use {@link #getInstance()} method only if you know exactly what you are doing.
 * 
 * @author Jevgeni Kabanov (ekabanov@zeroturnaround.com)
 * @author Aleksei Sosnovski
 */
public class LoggerFactory {
  private static final Logger INSTANCE;

  static {
    Logger inst = null;
    try {
      Class<?> loggerClass = Class.forName("com.zeroturnaround.javarebel.SDKLoggerImpl");
      inst = (Logger) loggerClass.newInstance();
    }
    catch (ClassNotFoundException e) {
    }
    catch (InstantiationException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    catch (IllegalAccessException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }

    // "Do nothing" implementation
    if (inst == null) {
      inst = new Logger() {
        final StopWatch dummy = new StopWatch() {
          public void stop() {
          }
          public String toString() {
            return "no-op stopwatch";
          }
        };

        public void error(String message) {
        }
        
        public void error(String format, Object arg) {
        }
        
        public void error(String format, Object arg1, Object arg2) {
        }
        
        public void error(String format, Object... args) {
        }
        
        public void error(String message, Throwable e) {
        }
        
        public void warn(String message) {
        }
        
        public void warn(String format, Object arg) {
        }
        
        public void warn(String format, Object arg1, Object arg2) {
        }
        
        public void warn(String format, Object... args) {
        }
        
        public void warn(String message, Throwable e) {
        }
        
        public void info(String message) {
        }
        
        public void info(String format, Object arg) {
        }
        
        public void info(String format, Object arg1, Object arg2) {
        }
        
        public void info(String format, Object... args) {
        }
        
        public void info(String message, Throwable e) {
        }
        
        public void debug(String message) {
        }
        
        public void debug(String format, Object arg) {
        }
        
        public void debug(String format, Object arg1, Object arg2) {
        }
        
        public void debug(String format, Object... args) {
        }
        
        public void debug(String message, Throwable e) {
        }
        
        public void trace(String message) {
        }
        
        public void trace(String format, Object arg) {
        }
        
        public void trace(String format, Object arg1, Object arg2) {
        }
        
        public void trace(String format, Object... args) {
        }
        
        public void trace(String message, Throwable e) {
        }

        public StopWatch createStopWatch(String category) {
          return dummy;
        }

        
        public boolean isErrorEnabled() {
          return false;
        }
        
        public boolean isWarnEnabled() {
          return false;
        }
        
        public boolean isInfoEnabled() {
          return false;
        }
        
        public boolean isDebugEnabled() {
          return false;
        }
        
        public boolean isTraceEnabled() {
          return false;
        }
        
        
        public void errorEcho(String message) {
        }

        public void errorEcho(String message, Object... args) {
        }

        public void errorEcho(String message, Throwable e) {
        }
        
        public void warnEcho(String message) {
        }

        public void warnEcho(String message, Object... args) {
        }

        public void warnEcho(String message, Throwable e) {
        }
        
        public void infoEcho(String message) {
        }

        public void infoEcho(String message, Object... args) {
        }

        public void infoEcho(String message, Throwable e) {
        }
        

        public Logger prefix(String prefix) {
          return this;
        }

        public Logger productPrefix(String prefix) {
          return this;
        }
        
        public void echo(String message) {
        }

        public void echo() {
        }

        public void echoPrefix(String message) {
        }
        
        public void errorEcho(Throwable e) {
        }
        
        public void error(Throwable e) {
        }
        
        public void log(String message) {
        }
        
        public boolean isEnabled() {
          return false;
        }
      };
    }
    
    INSTANCE = inst;
  }

  /**
   * Utility method, works same as <code>getInstance().productPrefix(prefix)</code> 
   * 
   * @param prefix Prefix used for every log message. Should not be null.
   * 
   * @return a suitable {@link Logger} implementation.
   */
  public static Logger getLogger(String prefix) {
    return INSTANCE.productPrefix(prefix);
  }
  
  /**
   * @return a suitable {@link Logger} implementation.
   */
  public static Logger getInstance() {
    return INSTANCE;
  }
}
