/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

/**
 * A simple class loader filter callback that can either match or not match a class loader.
 * 
 * @since 3.1
 * 
 * @author Rein Raudjärv
 */
public interface ClassLoaderFilter {
  /**
   * @param cl the ClassLoader to check
   * @return true if the class loader matches the filter, false otherwise.
   */
  boolean matches(ClassLoader cl);
}
