/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

import java.io.File;

/**
 * A factory for {@link ResourceIntegration} that resolves a suitable implementation. 
 * Use {@link #getInstance()} method to get the {@link ResourceIntegration} instance.
 */
public class ResourceIntegrationFactory {
  private static final ResourceIntegration INSTANCE;
  
  static {
    ResourceIntegration inst = null;
    try {
      Class<?> integrationClass = Class.forName("com.zeroturnaround.javarebel.SDKResourceIntegrationImpl"); 
      inst = (ResourceIntegration) integrationClass.newInstance();
    }
    catch (ClassNotFoundException e) {
    }
    catch (InstantiationException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    catch (IllegalAccessException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    
    //"Do nothing" implementation
    if (inst == null) {
      inst = new ResourceIntegration() {
        public boolean isEnabled() {
          return false;
        }
        public boolean addFileListener(File root, FileEventListener listener) {
          return false;
        }
        public void removeFileListener(FileEventListener listener) {
        }
      };
    }
    INSTANCE = inst;
  }
  /**
   * Returns a suitable {@link ResourceIntegration} implementation.
   * @return a suitable {@link ResourceIntegration} implementation.
   */
  public static ResourceIntegration getInstance() {
    return INSTANCE;
  }

}
