/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;


/**
 * A class-to-resource resolution strategy. JavaRebel will use the resource
 * to monitor {@link Resource#lastModified()} for updates.
 * 
 * @author Jevgeni Kabanov
 */
public interface ClassResourceSource extends ResourceSource {
  /**
   * Should return the {@link Resource} that corresponds to the resource
   * that the given class is loaded from.
   * 
   * @param className name of the class to lookup
   * @return the Resource associated with the class
   * 
   * @see org.zeroturnaround.javarebel.support.FileResource
   * @see org.zeroturnaround.javarebel.support.URLResource
   */
  public Resource getClassResource(String className);
}
