/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

/**
 * A factory for {@link Configuration} that resolves a suitable implementation. 
 * Use {@link #getInstance()} method to get the {@link Configuration} instance.
 * 
 * @author Jevgeni Kabanov (ekabanov@zeroturnaround.com)
 */
public class ConfigurationFactory {
  private static final Configuration INSTANCE;
  
  static {
    Configuration inst = null;
    try {
      Class<?> configurationClass = Class.forName("com.zeroturnaround.javarebel.SDKConfigurationImpl"); 
      inst = (Configuration) configurationClass.newInstance();
    }
    catch (ClassNotFoundException e) {
    }
    catch (InstantiationException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    catch (IllegalAccessException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    
    //"Do nothing" implementation
    if (inst == null) {
      inst = new Configuration() {
        
        public String getProperty(String key) {
          return null;
        }
        
        public boolean getBoolean(String key) {
          return false;
        }

        public boolean getBoolean(String key, boolean defaultValue) {
          return defaultValue;
        }

        public int getCheckInterval() {
          return 1000;
        }
        
        public String getProductName() {
          return null;
        }
        
        public boolean isPluginEnabled(String id) {
          return false;
        }
        
        public void addExcludeFilter(ClassLoader cl) {
        }
        
        public void addExcludeFilter(String classLoaderClassName) {
        }
        
        public void addExcludeFilter(ClassLoaderFilter classLoaderFilter) {
        }
        
        public boolean isClassLoaderExcluded(ClassLoader cl) {
          return true;
        }
        
        public void addIncludeManagedFilter(ClassLoader cl) {
        }
        
        public void addExcludeManagedFilter(ClassLoader cl) {
        }
        
        public void addIncludeManagedFilter(ClassIdentityFilter classFilter) {
        }
        
        public void addExcludeManagedFilter(ClassIdentityFilter classFilter) {
        }
        
        public void addExcludeManagedFilter(ClassFilter classFilter) { 
        }

        public void addIncludeManagedFilter(ClassFilter classFilter) {
        }

        public void clearManagedFilters() {
        }

        public boolean isManagedClass(ClassLoader cl, String classname, Resource cr) {
          return false;
        }
        
        public boolean isManagedClassExcluded(ClassLoader cl, String classname) {
          return false;
        }

        public Resource getClassResource(ClassLoader cl, String classname) {
          return null;
        }

      };
    }
    INSTANCE = inst;
  }
  
  /**
   * Returns a suitable {@link Configuration} implementation.
   * @return a suitable {@link Configuration} implementation.
   */
  public static Configuration getInstance() {
    return INSTANCE;
  }
}
