package org.zeroturnaround.javarebel;

import java.util.Enumeration;

/**
 * Http servlet request interface visible to JRebel agent.
 * <p>
 * Separate interface is required as the <code>javax.servlet.http.HttpServletRequest</code>
 * interface is not loaded by the boot class loader.
 * </p>
 * <p>
 * In practice a bytecode processor makes <code>javax.servlet.http.HttpServletRequest</code>
 * to extend the given interface.
 * </p>
 */
public interface RebelHttpServletRequest {

  /**
   * Reconstructs the URL the client used to make the request.
   * The returned URL contains a protocol, server name, port
   * number, and server path, but it does not include query
   * string parameters.
   * <br>
   * <p>Because this method returns a <code>StringBuffer</code>,
   * not a string, you can modify the URL easily, for example,
   * to append query parameters.
   * <br>
   * <p>This method is useful for creating redirect messages
   * and for reporting errors.
   *
   * @return a <code>StringBuffer</code> object containing
   *         the reconstructed URL
   */
  StringBuffer getRequestURL(); // NOSONAR

  /**
   * Returns the part of this request's URL from the protocol
   * name up to the query string in the first line of the HTTP request.
   * The web container does not decode this String.
   *
   * @return a <code>String</code> containing
   *         the part of the URL from the
   *         protocol name up to the query string
   */
  String getRequestURI();

  /**
   * Returns the name of the HTTP method with which this
   * request was made, for example, GET, POST, or PUT.
   * Same as the value of the CGI variable REQUEST_METHOD.
   *
   * @return a <code>String</code>
   *         specifying the name
   *         of the method with which
   *         this request was made
   */
  String getMethod();

  /**
   * Returns the query string that is contained in the request
   * URL after the path. This method returns <code>null</code>
   * if the URL does not have a query string. Same as the value
   * of the CGI variable QUERY_STRING.
   *
   * @return a <code>String</code> containing the query
   *         string or <code>null</code> if the URL
   *         contains no query string. The value is not
   *         decoded by the container.
   */
  String getQueryString();

  /**
   * Returns the value of the specified request header
   * as a <code>String</code>. If the request did not include a header
   * of the specified name, this method returns <code>null</code>.
   * If there are multiple headers with the same name, this method
   * returns the first head in the request.
   * The header name is case insensitive. You can use
   * this method with any request header.
   *
   * @param name    a <code>String</code> specifying the
   *        header name
   *
   * @return      a <code>String</code> containing the
   *        value of the requested
   *        header, or <code>null</code>
   *        if the request does not
   *        have a header of that name
   */
  String getHeader(String name);

  /**
   * A access mirror for HttpServletRequest's method
   */
  Enumeration<String> getHeaderNames();

  /**
   * A access mirror for HttpServletRequest's method
   */

  Object getAttribute(String name);

  /**
   * A access mirror for HttpServletRequest's method
   */
  String getServletPath();

  /**
   * A access mirror for HttpServletRequest's method
   */
  String getPathInfo();
}