package org.zeroturnaround.javarebel;


import java.util.Collection;
import java.util.Set;

/**
 *
 * Rebel wrapper for ServletRegistration implementations to avoid classloader and API issues when accessing it from our plugins.
 * Since Servlet 3.0
 *
 * Reveals mapping removal methods that could be optionally implemented by us.
 */
public interface RebelServletRegistration {

  /**
   *
   * @param urlPattern the url pattern to be removed
   * @return true if removal was successful or no problems arose when success verification is not possible
   */
  boolean removeMapping(String urlPattern);

  /**
   * @return true if this implementation allows to remove mappings
   */
  boolean isRemoveSupported();

  /**
   Method inherited from original interface.
   Adds a servlet mapping with the given URL patterns for the Servlet represented by this ServletRegistration.
   If any of the specified URL patterns are already mapped to a different Servlet, no updates will be performed.
   If this method is called multiple times, each successive call adds to the effects of the former.
   @param
   urlPatterns the URL patterns of the servlet mapping
   @return
   the (possibly empty) Set of URL patterns that are already mapped to a different Servlet
   @throws
   java.lang.IllegalArgumentException if urlPatterns is null or empty
   java.lang.IllegalStateException if the ServletContext from which this ServletRegistration was obtained has already been initialized
   */
  Set<String> addMapping(String ... urlPatterns);

  /**
   Same as addMapping(String ... urlPatterns), but does not throw IllegalStateException if ServletContext is already initialized.
   @param
   urlPatterns the URL patterns of the servlet mapping
   @return
   the (possibly empty) Set of URL patterns that are already mapped to a different Servlet
   @throws
   java.lang.IllegalArgumentException if urlPatterns is null or empty
   */
  Set<String> jrAddMapping(String ... urlPatterns);

  /**
   * Method inherited from original interface.
   * Gets the currently available mappings of the Servlet represented by this ServletRegistration.
     If permitted, any changes to the returned Collection must not affect this ServletRegistration.
     @return
     a (possibly empty) Collection of the currently available mappings of the Servlet represented by this ServletRegistration
   */
  Collection<String> getMappings();
}
