/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.generic;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;

/**
 * Bytecode processor for delegating Servlet context's resource related methods.
 * 
 * <p>The servlet context instance must be first registered with JRebel.
 * Otherwise the resource providing is unaffected.</p>
 * 
 * @author Rein Raudjärv
 * 
 * @see org.zeroturnaround.javarebel.ServletIntegration
 * @see org.zeroturnaround.javarebel.RebelServletContext
 */
public class BaseServletContextImplClassBytecodeProcessor extends CacheAwareJavassistClassBytecodeProcessor {

  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("org.zeroturnaround.javarebel");

    CtClass[] stringParam = cp.get(new String[] {String.class.getName()});

    try {
      ctClass.getDeclaredMethod("getResource", stringParam).insertBefore(
          "{" +
          "  if ($0 instanceof RebelServletContext) {" +
          "    ServletIntegration integration = ServletIntegrationFactory.getInstance();" +
          "    RebelServletContext servletContext = (RebelServletContext) $0;" +
          "    if (integration.isResourceReplaced(servletContext, $1))" +
          "      return integration.getResource(servletContext, $1);" +
          "  }" +
          "}");
    }
    catch (NotFoundException ignored) {
    }

    try {
      ctClass.getDeclaredMethod("getResourceAsStream", stringParam).insertBefore(
          "{" +
          "  if ($0 instanceof RebelServletContext) {" +
          "    ServletIntegration integration = ServletIntegrationFactory.getInstance();" +
          "    RebelServletContext servletContext = (RebelServletContext) $0;" +
          "    if (integration.isResourceReplaced(servletContext, $1))" +
          "      return integration.getResourceAsStream(servletContext, $1);" +
          "  }" +
          "}");
    }
    catch (NotFoundException ignored) {
    }

    try {
      ctClass.getDeclaredMethod("getResourcePaths", stringParam).insertBefore(
          "{" +
          "  if ($0 instanceof RebelServletContext) {" +
          "    ServletIntegration integration = ServletIntegrationFactory.getInstance();" +
          "    RebelServletContext servletContext = (RebelServletContext) $0;" +
          "    if (integration.isResourceReplaced(servletContext, $1))" +
          "      return integration.getResourcePaths(servletContext, $1);" +
          "  }" +
          "}");
    }
    catch (NotFoundException ignored) {
    }

    try {
      ctClass.getDeclaredMethod("getRealPath", stringParam).insertBefore(
          "{" +
          "  if ($0 instanceof RebelServletContext) {" +
          "    ServletIntegration integration = ServletIntegrationFactory.getInstance();" +
          "    RebelServletContext servletContext = (RebelServletContext) $0;" +
          "    if (integration.isResourceReplaced(servletContext, $1))" +
          "      return integration.getRealPath(servletContext, $1);" +
          "  }" +
          "}");
    }
    catch (NotFoundException ignored) {
    }
  }
}
