/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.support;

import org.zeroturnaround.javarebel.ClassResourceSource;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.integration.util.ResourceUtil;


/**
 * Base class-to-resource resolution strategy.
 * 
 * <p>This provides the default implementation for finding class resources
 * leaving general resource finding methods still undefined.</p>   

 * @author Rein Raudjärv
 * 
 * @see org.zeroturnaround.javarebel.ClassResourceSource
 * @see org.zeroturnaround.javarebel.integration.util.ResourceUtil#getClassResource(org.zeroturnaround.javarebel.ResourceSource, String)
 */
public abstract class BaseClassResourceSource implements ClassResourceSource {

  /**
   * Finds the class resource with the given name.
   * 
   * <p>The implementation of
   * {@link ResourceUtil#getClassResource(org.zeroturnaround.javarebel.ResourceSource, String)}
   * is used here.
   * 
   * @param className the name of the class.
   * 
   * @return found class resource or <code>null</code> if nothing found.
   *
   * @see org.zeroturnaround.javarebel.integration.util.ResourceUtil#getClassResource(org.zeroturnaround.javarebel.ResourceSource, String)
   */
  public Resource getClassResource(String className) {
    return ResourceUtil.getClassResource(this, className);
  }

}
