/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.support;

import java.io.InputStream;
import java.net.URL;

import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.util.SecurityController;
import org.zeroturnaround.javarebel.integration.util.SecurityController.PrivilegedAction;

/**
 * @author Rein Raudjärv
 */
public class RestrictedClassClassPath implements ClassPath {
  private static final Logger jrLogger = LoggerFactory.getLogger("Util");

  /**
   * Creates a new instance of system class path.
   */
  public RestrictedClassClassPath() {
  }
  
  public InputStream openClassfile(String classname) {
    final String jarname = classname.replace('.', '/') + ".class";
    if (System.getSecurityManager() == null)
      return ClassLoader.getSystemResourceAsStream(jarname);

    return SecurityController.doWithoutSecurityManager(new PrivilegedAction<InputStream>() {
      public InputStream run() {
        return ClassLoader.getSystemResourceAsStream(jarname);
      }
    });
  }

  public URL find(String classname) {
    StopWatch sw = jrLogger.createStopWatch("RestrictedClassClassPath#find");
    try {
      final String jarname = classname.replace('.', '/') + ".class";
      if (System.getSecurityManager() == null) {
        return ClassLoader.getSystemResource(jarname);
      }
      return SecurityController.doWithoutSecurityManager(new PrivilegedAction<URL>() {
        public URL run() {
          return ClassLoader.getSystemResource(jarname);
        }
      });
    }
    finally {
      if (sw != null) sw.stop();
    }
  }

  public void close() {
  }
}