/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.support;

import java.io.InputStream;
import java.net.URL;

import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.util.SecurityController;
import org.zeroturnaround.javarebel.integration.util.SecurityController.PrivilegedAction;

public class RestrictedLoaderClassPath implements ClassPath {
  private static final Logger jrLogger = LoggerFactory.getLogger("Util");
  
  private ClassLoader cl;

  public RestrictedLoaderClassPath(ClassLoader cl)
  {
    this.cl = cl;
  }

  public String toString() {
    return cl.toString();
  }

  public InputStream openClassfile(String classname) {
    final String cname = classname.replace('.', '/') + ".class";

    if (System.getSecurityManager() == null)
      return cl.getResourceAsStream(cname);

    return SecurityController.doWithoutSecurityManager(new PrivilegedAction<InputStream>() {
      public InputStream run() {
        return cl.getResourceAsStream(cname);
      }
    });
  }

  public URL find(String classname) {
    StopWatch sw = jrLogger.createStopWatch("RestrictedLoaderClassPath#find");
    try {
      final String cname = classname.replace('.', '/') + ".class";

      if (System.getSecurityManager() == null)
        return cl.getResource(cname);
      else
        return SecurityController.doWithoutSecurityManager(new PrivilegedAction<URL>() {
          public URL run() {
            return cl.getResource(cname);
          }
        });
    }
    finally {
      if (sw != null)
        sw.stop();
    }
  }

  public void close() {
    this.cl = null;
  }
}