package org.zeroturnaround.javarebel.integration.util;

import java.nio.ByteBuffer;

public class ByteBufferConverter {

  public static byte[] convert(ByteBuffer byteBuffer) {
    final int position = byteBuffer.position();
    final int limit = byteBuffer.limit();
    if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0 && position == 0 && limit == byteBuffer.capacity()) {
      return byteBuffer.array();
    } else {
      byte[] bytes = new byte[limit - position];
      byteBuffer.duplicate().get(bytes);
      return bytes;
    }
  }
}
