package org.zeroturnaround.javarebel.integration.util;

/**
 * Utility for temporary swapping the Thread.contextClassLoader.
 * ClassLoader will be switched only if tempClassLoader != null.
 * Example usage:
 * <pre>
 * ContextLClassLoaderSwapper classLoaderSwapper = new ContextLClassLoaderSwapper(tempCl).swap();
 * try {
 *   ...
 * } finally {
 *   classLoaderSwapper.restore();
 * }
 * </pre>
 */
public class ContextLClassLoaderSwapper {
  private final ClassLoader tempClassLoader;
  private ClassLoader initialClassLoader;

  public ContextLClassLoaderSwapper(ClassLoader tempClassLoader) {
    this.tempClassLoader = tempClassLoader;
  }

  public ContextLClassLoaderSwapper swap() {
    initialClassLoader = (tempClassLoader != null) ? MiscUtil.setContextClassLoader(tempClassLoader) : null;
    return this;
  }

  public void restore() {
    if (tempClassLoader != null) {
      MiscUtil.setContextClassLoader(initialClassLoader);
    }
  }
}