package org.zeroturnaround.javarebel.integration.generic;

import org.zeroturnaround.javarebel.ClassEventListener;
import org.zeroturnaround.javarebel.integration.util.WeakUtil;

public class ClassEventListenerAdapter implements ClassEventListener {

  public final ClassEventListener weak;
  private final int priority;

  public ClassEventListenerAdapter() {
    this(ClassEventListener.PRIORITY_DEFAULT);
  }

  public ClassEventListenerAdapter(int priority) {
    this.priority = priority;
    this.weak = WeakUtil.weak(this);
  }

  public int priority() {
    return priority;
  }
}
