package org.zeroturnaround.javarebel.integration.generic;


import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

/**
 * Processor making the class implement the given interface only if it is not already doing so.
 */
public class ImplementInterfaceCBP extends CacheAwareJavassistClassBytecodeProcessor {
  private static Logger log = LoggerFactory.getLogger(ImplementInterfaceCBP.class.getSimpleName());

  private final Class<?> interfaceToImplement;

  private ImplementInterfaceCBP(Class<?> clazz) {
    this.interfaceToImplement = clazz;
  }

  public static JavassistClassBytecodeProcessor getInstance(Class<?> clazz) {
    return new ImplementInterfaceCBP(clazz);
  }

  @Override
  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    if (!interfaceToImplement.isInterface()) {
      log.warn("Trying to make class implement a non interface " + interfaceToImplement.getName());
      return;
    }
    CtClass[] interfaces = ctClass.getInterfaces();
    for (int i = 0; i < interfaces.length; i++) {
      if (interfaceToImplement.getName().equals(interfaces[i].getName()))
        return; // already patched
    }

    ctClass.addInterface(cp.get(interfaceToImplement.getName()));
  }

  @Override
  protected CachingPolicy getCachingPolicy(ClassPool cp, ClassLoader cl) {
    return CachingPolicy.NEVER;
  }
}