/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;

/**
 * Provides static methods for monitoring logging methods invoked from user code.
 *
 */
public class LogMonitorHelper {

  private static Logger log = LoggerFactory.getLogger("LogMonitor");
  private static String monitorRegex = null;

  static {
    String regexCandidate = ConfigurationFactory.getInstance().getProperty("rebel.log.monitor.regex"); // TODO: hardcoded

    if (regexCandidate != null) {
      try {
        regexCandidate = regexCandidate.replaceAll("^\"|^\'|\"$|\'$", ""); // strip leading/trailing quotes.
        Pattern.compile(regexCandidate); // verify that the supplied regex is actually correct.
        monitorRegex = regexCandidate;
        log.info("Setup log monitor with regex pattern '{}'", monitorRegex);
      }
      catch (PatternSyntaxException e) {
        log.info("The supplied regex pattern '{}' was invalid", regexCandidate);
      }
    }
  }

  public static boolean shouldMonitorLogMethod() {
    return monitorRegex != null;
  }

  public static void monitorLogMethod(Object o) {
    if (o != null) {
      String s = o.toString();
      if (s.matches(monitorRegex)) {
        String message = "Output string '" + s + "' matched regex '" + monitorRegex + "', call stack: \n";
        StringBuilder sb = new StringBuilder(message);
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        for (int i = 2; i < stackTrace.length; i++) {
          sb.append("\t").append(stackTrace[i]).append("\n");
        }
        log.info(sb.toString());
      }
    }
  }

}
