/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

/**
 * Map implementation that is always empty.
 * <p>
 * Put operations are just ignored.
 * 
 * @author Jevgeni Kabanov
 */
public class NopMap<K,V> implements Map<K,V> {

  public void clear() {
  }

  public boolean containsKey(Object key) {
    return false;
  }

  public boolean containsValue(Object value) {
    return false;
  }

  public Set<Map.Entry<K, V>> entrySet() {
    return Collections.emptySet();
  }

  public V get(Object key) {
    return null;
  }

  public boolean isEmpty() {
    return true;
  }

  public Set<K> keySet() {
    return Collections.emptySet();
  }

  public V put(K key, V value) {
    return null;
  }

  public void putAll(Map<? extends K, ? extends V> t) {
  }

  public V remove(Object key) {
    return null;
  }

  public int size() {
    return 0;
  }

  public Collection<V> values() {
    return Collections.emptySet();
  }

}
