package org.zeroturnaround.javarebel.integration.util;

import org.zeroturnaround.javarebel.ConfigurationFactory;

/**
 * Utility for throttling method runs for at least {@code checkInterval}
 * Example usage:
 * <pre>
 * private final ReRunThrottler throttler = new ReRunThrottler(ConfigurationFactory.getInstance().getCheckInterval());
 * ...
 * public void someMethod() {
 *   if (throttler.shouldThrottle()) return;
 *   // do stuff
 * }
 * </pre>
 */
public class ReRunThrottler {
  public final int checkInterval;
  private long lastCheck = System.currentTimeMillis();

  public ReRunThrottler() {
    this(ConfigurationFactory.getInstance().getCheckInterval());
  }

  public ReRunThrottler(int checkInterval) {
    this.checkInterval = checkInterval;
  }

  public synchronized boolean shouldThrottle() {
    long currentTimeMillis = System.currentTimeMillis();
    if (lastCheck + checkInterval > currentTimeMillis)
      return true;
    lastCheck = currentTimeMillis;
    return false;
  }
}