/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.generic;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

public class ImplementInterfaceCBP
extends CacheAwareJavassistClassBytecodeProcessor {
    private static Logger log = LoggerFactory.getLogger((String)ImplementInterfaceCBP.class.getSimpleName());
    private final Class<?> interfaceToImplement;

    private ImplementInterfaceCBP(Class<?> clazz) {
        this.interfaceToImplement = clazz;
    }

    public static JavassistClassBytecodeProcessor getInstance(Class<?> clazz) {
        return new ImplementInterfaceCBP(clazz);
    }

    @Override
    public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
        if (!this.interfaceToImplement.isInterface()) {
            log.warn("Trying to make class implement a non interface " + this.interfaceToImplement.getName());
            return;
        }
        CtClass[] interfaces = ctClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!this.interfaceToImplement.getName().equals(interfaces[i].getName())) continue;
            return;
        }
        ctClass.addInterface(cp.get(this.interfaceToImplement.getName()));
    }

    @Override
    protected CacheAwareJavassistClassBytecodeProcessor.CachingPolicy getCachingPolicy(ClassPool cp, ClassLoader cl) {
        return CacheAwareJavassistClassBytecodeProcessor.CachingPolicy.NEVER;
    }
}

