/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.generic;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.zeroturnaround.javarebel.Resource;

public final class RestrictedResource
implements Resource {
    private final AccessControlContext acc;
    private final Resource target;

    public static Resource newInstance(AccessControlContext acc, Resource target) {
        if (acc == null || target == null) {
            return null;
        }
        return new RestrictedResource(acc, target);
    }

    private RestrictedResource(AccessControlContext acc, Resource target) {
        this.acc = acc;
        this.target = target;
    }

    public Resource getTarget() {
        return this.target;
    }

    public byte[] getBytes() {
        if (System.getSecurityManager() == null) {
            return this.target.getBytes();
        }
        return AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                return RestrictedResource.this.target.getBytes();
            }
        }, this.acc);
    }

    public long lastModified() {
        if (System.getSecurityManager() == null) {
            return this.target.lastModified();
        }
        Long obj = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return RestrictedResource.this.target.lastModified();
            }
        }, this.acc);
        return obj;
    }

    public URL toURL() {
        if (System.getSecurityManager() == null) {
            return this.target.toURL();
        }
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return RestrictedResource.this.target.toURL();
            }
        }, this.acc);
    }

    public String toString() {
        return "Privileged(" + this.targetToString() + ")";
    }

    private String targetToString() {
        if (System.getSecurityManager() == null) {
            return this.target.toString();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return RestrictedResource.this.target.toString();
            }
        });
    }
}

