/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.generic;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;

public class StandardClassLoaderCBP
extends CacheAwareJavassistClassBytecodeProcessor {
    @Override
    public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
        cp.importPackage("org.zeroturnaround.javarebel");
        cp.importPackage("org.zeroturnaround.javarebel.integration.generic");
        this.patchConstructors(ctClass);
        this.patchFindClass(cp, ctClass);
        this.patchFindResource(cp, ctClass);
        this.patchFindResources(cp, ctClass);
    }

    private void patchConstructors(CtClass ctClass) throws CannotCompileException {
        CtConstructor[] constructors = ctClass.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (!constructors[i].callsSuper()) continue;
            constructors[i].insertAfter("IntegrationFactory.getInstance().registerClassLoader($0, new FindResourceClassResourceSource($0));");
        }
    }

    protected void patchFindClass(ClassPool cp, CtClass ctClass) throws CannotCompileException, NotFoundException {
        try {
            CtMethod findClassMethod = ctClass.getDeclaredMethod("findClass", cp.get(new String[]{String.class.getName()}));
            findClassMethod.insertBefore("{  Class result = findLoadedClass($1);  if (result != null)    return result;  result = IntegrationFactory.getInstance().findReloadableClass($0, $1);  if (result != null)   return result;}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void patchFindResource(ClassPool cp, CtClass ctClass) throws CannotCompileException {
        try {
            CtClass[] params = cp.get(new String[]{String.class.getName()});
            CtMethod method = ctClass.getDeclaredMethod("findResource", params);
            method.insertBefore("Integration integration = IntegrationFactory.getInstance();if (integration.isResourceReplaced($0, $1)) {  return integration.findResource($0, $1);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void patchFindResources(ClassPool cp, CtClass ctClass) throws CannotCompileException {
        try {
            CtClass[] params = cp.get(new String[]{String.class.getName()});
            CtMethod method = ctClass.getDeclaredMethod("findResources", params);
            method.insertBefore("Integration integration = IntegrationFactory.getInstance();if (integration.isResourceReplaced($0, $1)) {  return integration.findResources($0, $1);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

