/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.monitor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.FileEventListener;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.RebelSource;
import org.zeroturnaround.javarebel.ResourceIntegrationFactory;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.WeakUtil;
import org.zeroturnaround.javarebel.support.ResourceUtils;

public class FileMonitorAdapter {
    private static final Logger log = LoggerFactory.getLogger((String)"FileMonitorAdapter");
    private static final int CHECK_INTERVAL = ConfigurationFactory.getInstance().getCheckInterval();
    private final Set<File> monitoredFiles = Collections.synchronizedSet(new HashSet());
    private final Map<File, Long> files = Collections.synchronizedMap(new HashMap());
    private final DirtyListener innerDirListener = new DirtyListener(false);
    private final FileEventListener listenerDir = WeakUtil.weak(this.innerDirListener);
    private final DirtyListener innerFileListener = new DirtyListener(false);
    private final FileEventListener listenerFile = WeakUtil.weak(this.innerFileListener);
    private final DirtyListener innerRecursiveListener = new DirtyListener(true);
    private final FileEventListener listenerRecursive = WeakUtil.weak(this.innerRecursiveListener);
    private final boolean onlyAdd;
    private volatile long lastScan = System.currentTimeMillis();
    private volatile boolean failed = false;
    private volatile boolean directories = false;

    public FileMonitorAdapter() {
        this(false);
    }

    public FileMonitorAdapter(boolean onlyAdd) {
        this.onlyAdd = onlyAdd;
        log.info("Created " + MiscUtil.identityToString(this) + " with d=" + MiscUtil.identityToString(this.listenerDir) + " and f=" + MiscUtil.identityToString(this.listenerFile) + "and r=" + MiscUtil.identityToString(this.listenerRecursive));
    }

    public void addFile(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException e) {
            f = f.getAbsoluteFile();
        }
        if (!f.exists()) {
            return;
        }
        if (!this.monitoredFiles.add(f)) {
            return;
        }
        if (!f.isDirectory()) {
            this.files.put(f, f.lastModified());
            if (!ResourceIntegrationFactory.getInstance().addFileListener(f.getParentFile(), this.listenerFile)) {
                this.failed = true;
            }
        } else {
            this.directories = true;
            if (!ResourceIntegrationFactory.getInstance().addFileListener(f, this.listenerDir)) {
                this.failed = true;
            }
        }
    }

    public void addRecursiveDir(URL url) {
        if (ResourceUtils.isFileURL((URL)url)) {
            this.addRecursiveDir(ResourceUtils.getFile((URL)url));
        }
    }

    public void addRecursiveDir(RebelSource rebelSource) {
        this.addRecursiveDir(rebelSource.getDir());
    }

    public void addRecursiveDir(File f) {
        this.directories = true;
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException e) {
            f = f.getAbsoluteFile();
        }
        if (!this.monitoredFiles.add(f)) {
            return;
        }
        if (f.isDirectory() && !ResourceIntegrationFactory.getInstance().addFileListener(f, this.listenerRecursive)) {
            this.failed = true;
        }
    }

    public boolean hasAnyPaths() {
        return this.monitoredFiles.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        Map<File, Long> map = this.files;
        synchronized (map) {
            if (this.lastScan + (long)CHECK_INTERVAL < System.currentTimeMillis()) {
                log.trace("Checking {} for changes {}", (Object)this);
                if (this.failed || this.isAnyDirty()) {
                    boolean result;
                    boolean bl = result = this.failed && this.directories;
                    if (this.directories && (this.innerDirListener.dirty || this.innerRecursiveListener.dirty)) {
                        result = true;
                    }
                    if (!(!this.innerFileListener.dirty && !this.failed || this.failed && this.directories)) {
                        result |= this.checkFiles();
                    }
                    this.reset();
                    return result;
                }
                this.lastScan = System.currentTimeMillis();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFiles() {
        StopWatch sw = log.createStopWatch("DirtyCheck");
        try {
            boolean result = false;
            for (Map.Entry<File, Long> e : this.files.entrySet()) {
                long last = e.getKey().lastModified();
                if (last == e.getValue()) continue;
                e.setValue(last);
                result = true;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (sw != null) {
                sw.stop();
            }
        }
    }

    private boolean isAnyDirty() {
        return this.innerDirListener.dirty || this.innerFileListener.dirty || this.innerRecursiveListener.dirty;
    }

    public void reset() {
        this.innerDirListener.reset();
        this.innerFileListener.reset();
        this.innerRecursiveListener.reset();
        this.lastScan = System.currentTimeMillis();
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
        return MiscUtil.identityToString(this) + " scanned at " + dateFormat.format(new Date(this.lastScan)) + (this.isAnyDirty() ? " dirty" : "") + (this.failed ? " failed" : "") + (this.directories ? " directories" : "") + (this.files.size() > 0 ? " files:" + this.files.size() : "");
    }

    public void destroy() {
        ResourceIntegrationFactory.getInstance().removeFileListener(this.listenerDir);
        ResourceIntegrationFactory.getInstance().removeFileListener(this.listenerFile);
        ResourceIntegrationFactory.getInstance().removeFileListener(this.listenerRecursive);
        this.files.clear();
        this.monitoredFiles.clear();
    }

    private class DirtyListener
    implements FileEventListener {
        private final boolean recursive;
        volatile boolean dirty;

        DirtyListener(boolean recursive) {
            this.recursive = recursive;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public void onFileAdd(File file) {
            if (!this.dirty) {
                log.info("{} detected adding of {}", (Object)MiscUtil.identityToString(this), (Object)file);
            }
            this.dirty = true;
        }

        public void onFileChange(File file) {
            if (!FileMonitorAdapter.this.onlyAdd) {
                if (!this.dirty) {
                    log.info("{} detected change in {}", (Object)MiscUtil.identityToString(this), (Object)file);
                }
                this.dirty = true;
            }
        }

        public void onFileRemove(File file) {
            if (!FileMonitorAdapter.this.onlyAdd) {
                if (!this.dirty) {
                    log.info("{} detected removing of {}", (Object)MiscUtil.identityToString(this), (Object)file);
                }
                this.dirty = true;
            }
        }

        public void onFileDirty(File file) {
            if (!this.dirty) {
                log.info("{} detected dirty event on {}", (Object)MiscUtil.identityToString(this), (Object)file);
            }
            this.dirty = true;
        }

        public void onFailure() {
            FileMonitorAdapter.this.failed = true;
        }

        void reset() {
            this.dirty = false;
        }

        public String toString() {
            return MiscUtil.identityToString(this) + (this.recursive ? " is recursive" : "") + (this.dirty ? " is dirty" : "") + " in " + MiscUtil.identityToString(FileMonitorAdapter.this);
        }
    }
}

