/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.monitor;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.RebelSource;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.monitor.MonitoredResource;
import org.zeroturnaround.javarebel.integration.util.ResourceUtil;
import org.zeroturnaround.javarebel.integration.util.WeakIdentityHashMap;
import org.zeroturnaround.javarebel.support.ResourceUtils;

public class MonitoredResourceManager {
    private static final Logger log = LoggerFactory.getLogger((String)"MonitoredResourceManager");
    private static final ThreadLocal<Object> builderLocal = new ThreadLocal();
    private static final Map<Object, MonitoredResourceManager> managersPerBuilder = Collections.synchronizedMap(new WeakIdentityHashMap());
    private static final Map<Class<?>, URL> classToURL = Collections.synchronizedMap(new WeakHashMap());
    private static final long MODIFIED_CHECK_MIN_INTERVAL = ConfigurationFactory.getInstance().getCheckInterval();
    private final Map<URL, MonitoredResource> monitoredConfs = Collections.synchronizedMap(new HashMap());
    private final Set<File> monitoredDirs = new HashSet<File>();
    private final List<RebelSource> rebelSources = new ArrayList<RebelSource>();
    private long lastCheck = System.currentTimeMillis();

    public static void beginConf(Object builder) {
        builderLocal.set(builder);
    }

    public static void endConf() {
        builderLocal.set(null);
    }

    public static Object getConf() {
        return builderLocal.get();
    }

    private static synchronized MonitoredResourceManager get(Object builder) {
        return managersPerBuilder.get(builder);
    }

    private static synchronized MonitoredResourceManager getOrCreate(Object builder) {
        MonitoredResourceManager manager = managersPerBuilder.get(builder);
        if (manager == null) {
            manager = new MonitoredResourceManager();
            managersPerBuilder.put(builder, manager);
        }
        return manager;
    }

    public static Set<String> modified(Object builder) {
        MonitoredResourceManager manager = MonitoredResourceManager.get(builder);
        return manager == null ? Collections.emptySet() : manager.modified();
    }

    private synchronized Set<String> modified() {
        if (System.currentTimeMillis() < this.lastCheck + MODIFIED_CHECK_MIN_INTERVAL) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (MonitoredResource mr : this.monitoredConfs.values()) {
            if (!mr.modified()) continue;
            result.add(mr.toString());
        }
        this.lastCheck = System.currentTimeMillis();
        return result;
    }

    public static void registerScannedRebelSource(RebelSource rs) {
        Object builder = MonitoredResourceManager.getConf();
        if (builder == null) {
            log.error((Throwable)new IllegalArgumentException("No builder provided"));
            return;
        }
        MonitoredResourceManager manager = MonitoredResourceManager.getOrCreate(builder);
        if (!manager.rebelSources.contains(rs)) {
            manager.rebelSources.add(rs);
        }
    }

    public static Collection<RebelSource> getScannedRebelSource() {
        MonitoredResourceManager manager = MonitoredResourceManager.get(MonitoredResourceManager.getConf());
        if (manager == null) {
            return null;
        }
        return manager.rebelSources;
    }

    public static void registerScannedDir(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        Object builder = MonitoredResourceManager.getConf();
        if (builder == null) {
            log.error((Throwable)new IllegalArgumentException("No builder provided"));
            return;
        }
        MonitoredResourceManager manager = MonitoredResourceManager.getOrCreate(builder);
        manager.monitoredDirs.add(dir);
    }

    public static Collection<File> getScannedDir() {
        MonitoredResourceManager manager = MonitoredResourceManager.get(MonitoredResourceManager.getConf());
        if (manager == null) {
            return null;
        }
        return manager.monitoredDirs;
    }

    public static void registerConf(Class<?> klass) {
        MonitoredResourceManager.registerConf(klass, MonitoredResourceManager.getConf());
    }

    public static void registerConf(ClassLoader classLoader, String className) {
        MonitoredResourceManager.registerConf(classLoader, className, MonitoredResourceManager.getConf());
    }

    public static void registerConf(URL url) {
        MonitoredResourceManager.registerConf(url, MonitoredResourceManager.getConf());
    }

    public static void registerConf(String url) {
        MonitoredResourceManager.registerConf(url, MonitoredResourceManager.getConf());
    }

    public static void registerConf(Class<?> klass, Object builder) {
        if (klass == null) {
            return;
        }
        MonitoredResourceManager.registerConf(MonitoredResourceManager.toURL(klass), builder);
    }

    public static void registerConf(ClassLoader classLoader, String className, Object builder) {
        MonitoredResourceManager.registerConf(MonitoredResourceManager.toURL(classLoader, className), builder);
    }

    private static URL toURL(Class<?> klass) {
        URL url = classToURL.get(klass);
        if (url != null) {
            return url;
        }
        url = MonitoredResourceManager.toURL(klass.getClassLoader(), klass.getName());
        if (url != null) {
            classToURL.put(klass, url);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL toURL(ClassLoader classLoader, String className) {
        StopWatch sw = log.createStopWatch("MonitoredResourceManager#toURL");
        try {
            if (classLoader != null) {
                URL uRL = classLoader.getResource(className.replace('.', '/') + ".class");
                return uRL;
            }
            URL uRL = null;
            return uRL;
        }
        finally {
            sw.stop();
        }
    }

    public static void registerConf(String url, Object builder) {
        URL u;
        if (url == null) {
            return;
        }
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            log.echoPrefix("Warning! Could not monitor configuration in '" + url + "'.");
            log.error((Throwable)e);
            return;
        }
        MonitoredResourceManager.registerConf(u, builder);
    }

    public static void registerConf(URL url, Object builder) {
        if (url == null || ResourceUtils.isJarURL((URL)url) || "bundleresource".equals(url.getProtocol())) {
            return;
        }
        if (builder == null) {
            log.log("Warning! Could not monitor configuration in '" + url + "'.");
            log.error((Throwable)new IllegalArgumentException("No builder provided"));
            return;
        }
        MonitoredResourceManager.getOrCreate(builder).register(url);
    }

    public static boolean confRegistered(String url, Object builder) {
        URL u;
        if (url == null) {
            return false;
        }
        MonitoredResourceManager monitoredResourceManager = MonitoredResourceManager.get(builder);
        if (monitoredResourceManager == null) {
            return false;
        }
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            log.echoPrefix("Warning! Could not create url in '" + url + "'.");
            log.error((Throwable)e);
            return false;
        }
        return monitoredResourceManager.monitoredConfs.containsKey(u);
    }

    private synchronized void register(URL url) {
        if (this.monitoredConfs.containsKey(url)) {
            return;
        }
        File file = ResourceUtils.getFile((URL)url);
        if (!file.isFile() && !"jndi".equals(url.getProtocol())) {
            log.trace("Ignored non-file configuration in '{}'", (Object)url);
            return;
        }
        log.info("Monitoring configuration in '{}'", (Object)url);
        this.monitoredConfs.put(url, new MonitoredResource(ResourceUtil.asResource(url)));
    }
}

