/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import java.util.ArrayList;
import java.util.List;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

public abstract class CBPs {
    public static DelayedProcessor implement(String intfName) {
        return new DelayedProcessor().addInterface(intfName);
    }

    public static DelayedProcessor implement(Class<?> intf) {
        return new DelayedProcessor().addInterface(intf);
    }

    public static DirectProcessor process(ClassPool cp, CtClass ctClass) {
        return new DirectProcessorImpl(cp, ctClass);
    }

    public static ExprEditor replaceMethodCall(final String methodName, final String src) {
        return new ExprEditor(){

            public void edit(MethodCall m) throws CannotCompileException {
                if (m.getMethodName().equals(methodName)) {
                    m.replace(src);
                }
            }
        };
    }

    public static class DelayedProcessor
    extends JavassistClassBytecodeProcessor {
        private List<String> intfs = new ArrayList<String>();
        private List<String> imports = new ArrayList<String>();
        private List<String> methods = new ArrayList<String>();

        public DelayedProcessor importPackage(String pkg) {
            this.imports.add(pkg);
            return this;
        }

        public DelayedProcessor addInterface(String intfName) {
            this.intfs.add(intfName);
            return this;
        }

        public DelayedProcessor addInterface(Class<?> intf) {
            this.intfs.add(intf.getName());
            return this;
        }

        public DelayedProcessor addMethod(String method) {
            this.methods.add(method);
            return this;
        }

        public DelayedProcessor withMethod(String method) {
            return this.addMethod(method);
        }

        @Override
        public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
            DirectProcessor processor = CBPs.process(cp, ctClass);
            for (String anImport : this.imports) {
                processor = processor.importPackage(anImport);
            }
            for (String intf : this.intfs) {
                processor = processor.addInterface(intf);
            }
            for (String method : this.methods) {
                processor = processor.addMethod(method);
            }
        }
    }

    private static class DirectProcessorImpl
    implements DirectProcessor {
        private ClassPool cp;
        private CtClass ctClass;

        DirectProcessorImpl(ClassPool cp, CtClass ctClass) {
            this.cp = cp;
            this.ctClass = ctClass;
        }

        @Override
        public DirectProcessor skipIfNoField(String fieldName) {
            try {
                this.ctClass.getDeclaredField(fieldName);
            }
            catch (NotFoundException e) {
                return NopDirectProcessor.INSTANCE;
            }
            return this;
        }

        @Override
        public DirectProcessor skipIfNoMethod(String methodName) {
            try {
                this.ctClass.getDeclaredMethod(methodName);
            }
            catch (NotFoundException e) {
                return NopDirectProcessor.INSTANCE;
            }
            return this;
        }

        @Override
        public DirectProcessor skipIfNoClass(String className) {
            if (this.cp.getOrNull(className) == null) {
                return NopDirectProcessor.INSTANCE;
            }
            return this;
        }

        @Override
        public DirectProcessor importPackage(String pkg) {
            this.cp.importPackage(pkg);
            return this;
        }

        @Override
        public DirectProcessor addInterface(String intfName) throws NotFoundException {
            this.ctClass.addInterface(this.cp.get(intfName));
            return this;
        }

        @Override
        public DirectProcessor addInterface(Class<?> intf) throws NotFoundException {
            this.ctClass.addInterface(this.cp.get(intf.getName()));
            return this;
        }

        @Override
        public DirectProcessor addMethod(String method) throws CannotCompileException {
            this.ctClass.addMethod(CtNewMethod.make((String)method, (CtClass)this.ctClass));
            return this;
        }

        @Override
        public DirectProcessor addLocalVariableTo(String methodName, Class<?> variableClass, String variableName, String initExpr) throws CannotCompileException, NotFoundException {
            CtMethod declaredMethod = this.ctClass.getDeclaredMethod(methodName);
            declaredMethod.addLocalVariable(variableName, this.cp.get(variableClass.getName()));
            declaredMethod.insertBefore(variableName + " = " + initExpr + ";");
            return this;
        }

        @Override
        public DirectProcessor insertAfterClinit(String src) throws CannotCompileException {
            this.ctClass.makeClassInitializer().insertAfter(src);
            return this;
        }

        @Override
        public DirectProcessor insertAfterLeafCtors(String src) throws CannotCompileException {
            for (CtConstructor ctor : this.ctClass.getDeclaredConstructors()) {
                if (!ctor.callsSuper()) continue;
                ctor.insertAfter(src);
            }
            return this;
        }

        @Override
        public DirectProcessor instrument(String methodName, ExprEditor exprEditor) throws NotFoundException, CannotCompileException {
            this.ctClass.getDeclaredMethod(methodName).instrument(exprEditor);
            return this;
        }

        @Override
        public DirectProcessor instrumentAll(String methodName, ExprEditor exprEditor) throws NotFoundException, CannotCompileException {
            CtMethod[] methods;
            for (CtMethod method : methods = this.ctClass.getDeclaredMethods(methodName)) {
                method.instrument(exprEditor);
            }
            return this;
        }

        @Override
        public DirectProcessor importClass(Class<?> klass) {
            this.cp.importPackage(klass.getName());
            return this;
        }

        @Override
        public DirectProcessor addField(String field) throws CannotCompileException {
            this.ctClass.addField(CtField.make((String)field, (CtClass)this.ctClass));
            return this;
        }

        @Override
        public DirectProcessor removeFinalFromField(String field) {
            try {
                CtField declaredField = this.ctClass.getDeclaredField(field);
                declaredField.setModifiers(declaredField.getModifiers() & 0xFFFFFFEF);
            }
            catch (NotFoundException e) {
                return this;
            }
            return this;
        }

        @Override
        public DirectProcessor addLoggerField(String fieldName, String loggerName) throws CannotCompileException {
            return this.addField("private final static org.zeroturnaround.javarebel.Logger " + fieldName + " = org.zeroturnaround.javarebel.LoggerFactory.getLogger(\"" + loggerName + "\");");
        }

        @Override
        public DirectProcessor insertBefore(String methodName, String src) throws NotFoundException, CannotCompileException {
            this.ctClass.getDeclaredMethod(methodName).insertBefore(src);
            return this;
        }

        @Override
        public DirectProcessor insertBefore(String methodName, CtClass[] paramTypes, String src) throws NotFoundException, CannotCompileException {
            this.ctClass.getDeclaredMethod(methodName, paramTypes).insertBefore(src);
            return this;
        }

        @Override
        public DirectProcessor insertAfter(String methodName, String src) throws NotFoundException, CannotCompileException {
            this.ctClass.getDeclaredMethod(methodName).insertAfter(src);
            return this;
        }

        @Override
        public DirectProcessor insertBeforeLeafCtors(String src) throws CannotCompileException {
            for (CtConstructor ctor : this.ctClass.getConstructors()) {
                if (!ctor.callsSuper()) continue;
                ctor.insertBeforeBody(src);
            }
            return this;
        }
    }

    private static class NopDirectProcessor
    implements DirectProcessor {
        static final NopDirectProcessor INSTANCE = new NopDirectProcessor();

        private NopDirectProcessor() {
        }

        @Override
        public DirectProcessor skipIfNoField(String fieldName) {
            return this;
        }

        @Override
        public DirectProcessor skipIfNoMethod(String methodName) {
            return this;
        }

        @Override
        public DirectProcessor skipIfNoClass(String className) {
            return this;
        }

        @Override
        public DirectProcessor importPackage(String pkg) {
            return this;
        }

        @Override
        public DirectProcessor importClass(Class<?> klass) {
            return this;
        }

        @Override
        public DirectProcessor addInterface(String intfName) throws NotFoundException {
            return this;
        }

        @Override
        public DirectProcessor addInterface(Class<?> intf) throws NotFoundException {
            return this;
        }

        @Override
        public DirectProcessor addField(String field) throws CannotCompileException {
            return this;
        }

        @Override
        public DirectProcessor removeFinalFromField(String field) throws CannotCompileException {
            return this;
        }

        @Override
        public DirectProcessor addLoggerField(String fieldName, String loggerName) throws CannotCompileException {
            return this;
        }

        @Override
        public DirectProcessor addMethod(String method) throws CannotCompileException {
            return this;
        }

        @Override
        public DirectProcessor addLocalVariableTo(String methodName, Class<?> variableClass, String variableName, String initExpr) throws CannotCompileException, NotFoundException {
            return this;
        }

        @Override
        public DirectProcessor insertAfterClinit(String src) {
            return this;
        }

        @Override
        public DirectProcessor insertBeforeLeafCtors(String src) throws CannotCompileException {
            return this;
        }

        @Override
        public DirectProcessor insertAfterLeafCtors(String src) throws CannotCompileException {
            return this;
        }

        @Override
        public DirectProcessor insertBefore(String methodName, String src) throws NotFoundException, CannotCompileException {
            return this;
        }

        @Override
        public DirectProcessor insertBefore(String methodName, CtClass[] paramTypes, String src) throws NotFoundException, CannotCompileException {
            return this;
        }

        @Override
        public DirectProcessor insertAfter(String methodName, String src) throws NotFoundException, CannotCompileException {
            return this;
        }

        @Override
        public DirectProcessor instrument(String methodName, ExprEditor exprEditor) throws NotFoundException, CannotCompileException {
            return this;
        }

        @Override
        public DirectProcessor instrumentAll(String methodName, ExprEditor exprEditor) throws NotFoundException, CannotCompileException {
            return this;
        }
    }

    public static interface DirectProcessor {
        public DirectProcessor skipIfNoField(String var1);

        public DirectProcessor skipIfNoMethod(String var1);

        public DirectProcessor skipIfNoClass(String var1);

        public DirectProcessor importPackage(String var1);

        public DirectProcessor importClass(Class<?> var1);

        public DirectProcessor addInterface(String var1) throws NotFoundException;

        public DirectProcessor addInterface(Class<?> var1) throws NotFoundException;

        public DirectProcessor addField(String var1) throws CannotCompileException;

        public DirectProcessor removeFinalFromField(String var1) throws CannotCompileException;

        public DirectProcessor addLoggerField(String var1, String var2) throws CannotCompileException;

        public DirectProcessor addMethod(String var1) throws CannotCompileException;

        public DirectProcessor addLocalVariableTo(String var1, Class<?> var2, String var3, String var4) throws CannotCompileException, NotFoundException;

        public DirectProcessor insertAfterClinit(String var1) throws CannotCompileException;

        public DirectProcessor insertBeforeLeafCtors(String var1) throws CannotCompileException;

        public DirectProcessor insertAfterLeafCtors(String var1) throws CannotCompileException;

        public DirectProcessor insertBefore(String var1, String var2) throws NotFoundException, CannotCompileException;

        public DirectProcessor insertBefore(String var1, CtClass[] var2, String var3) throws NotFoundException, CannotCompileException;

        public DirectProcessor insertAfter(String var1, String var2) throws NotFoundException, CannotCompileException;

        public DirectProcessor instrument(String var1, ExprEditor var2) throws NotFoundException, CannotCompileException;

        public DirectProcessor instrumentAll(String var1, ExprEditor var2) throws NotFoundException, CannotCompileException;
    }
}

