/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

class RebelClassPool
extends ClassPool {
    private static final Logger log = LoggerFactory.getLogger((String)"SDK-CBP");
    private final JavassistClassBytecodeProcessor processor;
    private final String classname;
    private final boolean processingClassInDefaultPkg;

    public RebelClassPool(ClassPool systemClassPool, JavassistClassBytecodeProcessor processor, String classname) {
        super(systemClassPool);
        this.childFirstLookup = true;
        this.processor = processor;
        this.classname = classname;
        this.processingClassInDefaultPkg = this.isClassInDefaultPackage(classname);
    }

    public static void init() {
    }

    public CtClass get(String name) throws NotFoundException {
        String checked = name;
        if (checked.charAt(0) == '[') {
            checked = Descriptor.toClassName((String)checked);
        }
        while (checked.endsWith("[]")) {
            checked = checked.substring(0, checked.lastIndexOf(91));
        }
        if (this.classname.equals(checked) || this.processor.acceptPathAsPrimitive(checked)) {
            return super.get(name);
        }
        if (!this.processor.acceptPathAsClass(checked)) {
            throw new NotFoundException(name);
        }
        if (this.isClassInDefaultPackage(checked)) {
            CtClass result;
            if (this.processor.getImplicitClassNames() != null && (result = this.tryLoadFromImplicitImports(name, checked)) != null) {
                return result;
            }
            if (!this.processingClassInDefaultPkg) {
                throw new NotFoundException(name);
            }
        }
        return super.get(name);
    }

    private CtClass tryLoadFromImplicitImports(String name, String checked) throws NotFoundException {
        String fullClassName = this.processor.getImplicitClassNames().get(name);
        if (fullClassName != null) {
            return super.get(fullClassName);
        }
        log.trace("Did not find package for {} from {}", (Object)checked, (Object)name);
        return null;
    }

    public void clearCache() {
        this.classes.clear();
    }

    private boolean isClassInDefaultPackage(String classname) {
        return classname.lastIndexOf(46) == -1;
    }
}

