/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import java.io.InputStream;
import java.net.URL;
import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.util.SecurityController;

public class RestrictedClassClassPath
implements ClassPath {
    private static final Logger jrLogger = LoggerFactory.getLogger((String)"Util");

    public InputStream openClassfile(String classname) {
        final String jarname = classname.replace('.', '/') + ".class";
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemResourceAsStream(jarname);
        }
        return SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return ClassLoader.getSystemResourceAsStream(jarname);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL find(String classname) {
        StopWatch sw = jrLogger.createStopWatch("RestrictedClassClassPath#find");
        try {
            final String jarname = classname.replace('.', '/') + ".class";
            if (System.getSecurityManager() == null) {
                URL uRL = ClassLoader.getSystemResource(jarname);
                return uRL;
            }
            URL uRL = SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return ClassLoader.getSystemResource(jarname);
                }
            });
            return uRL;
        }
        finally {
            if (sw != null) {
                sw.stop();
            }
        }
    }

    public void close() {
    }
}

