/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import java.io.InputStream;
import java.net.URL;
import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.util.SecurityController;

public class RestrictedLoaderClassPath
implements ClassPath {
    private static final Logger jrLogger = LoggerFactory.getLogger((String)"Util");
    private ClassLoader cl;

    public RestrictedLoaderClassPath(ClassLoader cl) {
        this.cl = cl;
    }

    public String toString() {
        return this.cl.toString();
    }

    public InputStream openClassfile(String classname) {
        final String cname = classname.replace('.', '/') + ".class";
        if (System.getSecurityManager() == null) {
            return this.cl.getResourceAsStream(cname);
        }
        return SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return RestrictedLoaderClassPath.this.cl.getResourceAsStream(cname);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL find(String classname) {
        StopWatch sw = jrLogger.createStopWatch("RestrictedLoaderClassPath#find");
        try {
            final String cname = classname.replace('.', '/') + ".class";
            if (System.getSecurityManager() == null) {
                URL uRL = this.cl.getResource(cname);
                return uRL;
            }
            URL uRL = SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return RestrictedLoaderClassPath.this.cl.getResource(cname);
                }
            });
            return uRL;
        }
        finally {
            if (sw != null) {
                sw.stop();
            }
        }
    }

    public void close() {
        this.cl = null;
    }
}

