/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Collection;
import org.zeroturnaround.javarebel.ClassEventListener;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.ReflectionUtil;
import org.zeroturnaround.javarebel.integration.util.WeakUtil;

public class ClassEventListenerUtil {
    private static final Field contextClassLoaderField = ReflectionUtil.getDeclaredField(Thread.class, "contextClassLoader");

    public static ClassEventListener bindContextClassLoader(ClassEventListener listener) {
        return ClassEventListenerUtil.bindClassLoader(listener, ClassEventListenerUtil.getContextClassLoader());
    }

    public static ClassEventListener bindClassLoader(ClassEventListener listener, ClassLoader cl) {
        if (!ClassEventListenerUtil.canSetTCL() || cl == null) {
            return WeakUtil.weakCEL(listener);
        }
        return new BoundClassEventListener(listener, cl);
    }

    private static ClassLoader getContextClassLoader() {
        return MiscUtil.getContextClassLoader();
    }

    private static ClassLoader setContextClassLoader(ClassLoader cl) {
        if (!ClassEventListenerUtil.isOc4jThread()) {
            return MiscUtil.setContextClassLoader(cl);
        }
        ClassLoader old = ClassEventListenerUtil.reflGetContextClassLoader();
        ClassEventListenerUtil.reflSetContextClassLoader(cl);
        return old;
    }

    private static ClassLoader reflGetContextClassLoader() {
        try {
            return (ClassLoader)contextClassLoaderField.get(Thread.currentThread());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void reflSetContextClassLoader(ClassLoader cl) {
        try {
            contextClassLoaderField.set(Thread.currentThread(), cl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean canSetTCL() {
        return !ClassEventListenerUtil.isOc4jThread() || contextClassLoaderField != null;
    }

    private static boolean isOc4jThread() {
        return "com.evermind.server.ApplicationServerThread".equals(Thread.currentThread().getClass().getName());
    }

    private static class BoundClassEventListener
    implements ClassEventListener,
    WeakUtil.RemovableListener {
        private final WeakReference<ClassEventListener> targetRef;
        private final WeakReference<ClassLoader> classLoderRef;
        private final String identity;
        private final int priority;

        public BoundClassEventListener(ClassEventListener target, ClassLoader cl) {
            this.targetRef = new WeakUtil.WeakListenerReference<ClassEventListener>(this, target);
            this.classLoderRef = new WeakReference<ClassLoader>(cl);
            this.priority = target.priority();
            this.identity = "boundCL(" + MiscUtil.identityToString(cl) + ")[" + MiscUtil.dumpToString(target) + "]";
        }

        private ClassLoader getClassLoader() {
            return (ClassLoader)this.classLoderRef.get();
        }

        private ClassEventListener getTarget() {
            return (ClassEventListener)this.targetRef.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClassEvent(int eventType, Class<?> klass, Collection<ClassEventListener.ChangeType> changeTypes) throws Exception {
            ClassEventListener target = this.getTarget();
            if (target == null) {
                this.remove();
                return;
            }
            ClassLoader cl = this.getClassLoader();
            boolean hasCl = cl != null;
            ClassLoader old = hasCl ? ClassEventListenerUtil.setContextClassLoader(cl) : null;
            try {
                target.onClassEvent(eventType, klass, changeTypes);
            }
            finally {
                if (hasCl) {
                    ClassEventListenerUtil.setContextClassLoader(old);
                }
            }
        }

        public int priority() {
            return this.priority;
        }

        public String toString() {
            return this.identity;
        }

        @Override
        public void remove() {
            ReloaderFactory.getInstance().removeClassReloadListener((ClassEventListener)this);
        }
    }
}

