/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.zeroturnaround.javarebel.integration.util.FileUtil;

public class IoUtil {
    private static final int BUFFER_SIZE = 4096;

    public static void write(byte[] bytes, OutputStream out) throws IOException {
        IoUtil.copy(new ByteArrayInputStream(bytes), out);
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        int read;
        char[] buffer = new char[4096];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public static byte[] getBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtil.copy(in, out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesAndClose(Reader in) throws IOException {
        try {
            int numCharsRead;
            char[] charArray = new char[8192];
            StringBuilder builder = new StringBuilder();
            while ((numCharsRead = in.read(charArray, 0, charArray.length)) != -1) {
                builder.append(charArray, 0, numCharsRead);
            }
            byte[] byArray = builder.toString().getBytes();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] getBytesAndClose(InputStream in) {
        try {
            byte[] byArray = IoUtil.getBytes(in);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IoUtil.closeStream(in);
        }
    }

    public static void closeStream(Closeable in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static InputStream getInputStream(File file) {
        if (file.isDirectory()) {
            return null;
        }
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getURL(File file) {
        try {
            return FileUtil.toURI(file).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

