/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtBehavior;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.LoggerFactory;

public final class JavassistUtil {
    public static void init() {
    }

    public static boolean hasClass(ClassPool cp, String className) {
        try {
            return cp.getOrNull(className) != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean hasDeclaredMethod(CtClass ctClass, String methodName) {
        try {
            return ctClass != null && ctClass.getDeclaredMethod(methodName) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean hasDeclaredMethod(ClassPool cp, CtClass ctClass, String methodName, String[] param) {
        try {
            return ctClass.getDeclaredMethod(methodName, cp.get(param)) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean hasDeclaredMethod(ClassPool cp, String klazz, String methodName) {
        try {
            CtClass ctClass = cp.get(klazz);
            return ctClass != null && ctClass.getDeclaredMethod(methodName) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean hasDeclaredMethod(ClassPool cp, String klazz, String methodName, String[] param) {
        try {
            CtClass ctClass = cp.get(klazz);
            return ctClass != null && ctClass.getDeclaredMethod(methodName, cp.get(param)) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean hasDeclaredConstructor(ClassPool cp, String klazz, String ... param) {
        try {
            CtClass ctClass = cp.get(klazz);
            return ctClass != null && ctClass.getDeclaredConstructor(cp.get(param)) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean hasDeclaredConstructor(CtClass ctClass, String ... param) {
        try {
            return ctClass != null && ctClass.getDeclaredConstructor(ctClass.getClassPool().get(param)) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static CtConstructor getDeclaredConstructor(ClassPool cp, String klazz, String ... param) {
        try {
            return JavassistUtil.getDeclaredConstructor(cp.get(klazz), param);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static CtConstructor getDeclaredConstructor(CtClass ctClass, String ... param) {
        try {
            if (ctClass != null) {
                return ctClass.getDeclaredConstructor(ctClass.getClassPool().get(param));
            }
            return null;
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static boolean hasMethod(CtClass ctClass, String methodName) {
        try {
            for (CtMethod ctMethod : ctClass.getMethods()) {
                if (!methodName.equals(ctMethod.getName())) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean hasMethod(CtClass ctClass, String methodName, String methodDesc) {
        try {
            return ctClass.getMethod(methodName, methodDesc) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static CtClass getFirstExistingClass(ClassPool cp, String ... classNames) {
        for (String className : classNames) {
            try {
                return cp.get(className);
            }
            catch (NotFoundException notFoundException) {
            }
        }
        return null;
    }

    public static CtField getFirstExistingField(CtClass ctClass, String ... fieldNames) {
        if (ctClass == null) {
            return null;
        }
        for (String name : fieldNames) {
            try {
                return ctClass.getDeclaredField(name);
            }
            catch (NotFoundException notFoundException) {
            }
        }
        return null;
    }

    public static CtMethod getFirstExistingMethod(CtClass ctClass, String ... methodNames) {
        if (ctClass == null) {
            return null;
        }
        for (String name : methodNames) {
            try {
                return ctClass.getDeclaredMethod(name);
            }
            catch (NotFoundException notFoundException) {
            }
        }
        return null;
    }

    public static CtMethod getFirstExistingMethod(CtMethod first, ClassPool cp, CtClass ctClass, String methodName, Class<?> ... param) {
        if (first == null) {
            try {
                String[] classNames = new String[param.length];
                for (int i = 0; i < classNames.length; ++i) {
                    classNames[i] = param[i].getName();
                }
                return JavassistUtil.getFirstExistingMethod(null, cp, ctClass, methodName, classNames);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return first;
    }

    public static CtMethod getFirstExistingMethod(CtMethod first, ClassPool cp, CtClass ctClass, String methodName, String ... param) {
        if (first == null) {
            try {
                return ctClass.getDeclaredMethod(methodName, cp.get(param));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return first;
    }

    public static boolean hasDeclaredField(CtClass ctClass, String fieldName) {
        try {
            ctClass.getDeclaredField(fieldName);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean hasDeclaredField(ClassPool cp, String klazz, String fieldName) {
        try {
            CtClass ctClass = cp.get(klazz);
            return ctClass != null && ctClass.getDeclaredField(fieldName) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static CtField getDeclaredField(CtClass ctClass, String fieldName) {
        try {
            return ctClass.getDeclaredField(fieldName);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public static boolean hasMethodOnField(CtClass ctClass, String fieldName, String methodName, String ... paramClasses) {
        try {
            CtField field = ctClass.getField(fieldName);
            return field.getType().getDeclaredMethod(methodName, ctClass.getClassPool().get(paramClasses)) != null;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean implementsInterface(CtClass ctClass, String ifaceName) throws NotFoundException {
        try {
            CtClass[] ifaces;
            for (CtClass iface : ifaces = ctClass.getInterfaces()) {
                if (!iface.getName().equals(ifaceName) && !JavassistUtil.implementsInterface(iface, ifaceName)) continue;
                return true;
            }
            CtClass superclass = ctClass.getSuperclass();
            if (superclass != null && !superclass.getName().equals(Object.class.getName())) {
                return JavassistUtil.implementsInterface(superclass, ifaceName);
            }
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger((String)"Javassit").warn("Checking {} failed with: {}", (Object)ctClass.getName(), (Object)e.getMessage());
        }
        return false;
    }

    public static CtMethod getDeclaredMethod(CtClass ctClass, String methodName, String ... paramClasses) {
        try {
            return ctClass.getDeclaredMethod(methodName, ctClass.getClassPool().get(paramClasses));
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public static CtMethod getDeclaredMethodByDescriptor(CtClass ctClass, String methodName, String descriptorPrefix) throws NotFoundException {
        for (CtMethod method : ctClass.getDeclaredMethods(methodName)) {
            if (!method.getSignature().startsWith(descriptorPrefix)) continue;
            return method;
        }
        throw new NotFoundException(methodName);
    }

    public static CtMethod getDeclaredMethod(CtClass ctClass, String methodName) {
        try {
            return ctClass.getDeclaredMethod(methodName);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public static CtMethod getDeclaredMethod(CtClass ctClass, String methodName, Class<?> ... paramClasses) {
        String[] params = new String[paramClasses.length];
        for (int i = 0; i < paramClasses.length; ++i) {
            params[i] = paramClasses[i].getName();
        }
        return JavassistUtil.getDeclaredMethod(ctClass, methodName, params);
    }

    public static ExprEditor strictMethodCallReplacer(String methodName, String replaceStatement) {
        return new ValidatingMethodCallReplaceEditor(methodName, replaceStatement, 1);
    }

    public static boolean isMethodVisible(CtClass caller, String name) {
        for (CtClass declaring = caller; declaring != null; declaring = declaring.getSuperclass()) {
            try {
                int modifiers = declaring.getDeclaredMethod(name).getModifiers();
                if (declaring == caller || !Modifier.isPrivate((int)modifiers)) {
                    return true;
                }
            }
            catch (NotFoundException modifiers) {
                // empty catch block
            }
            try {
                continue;
            }
            catch (NotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isFieldVisible(CtClass user, String name) {
        for (CtClass declaring = user; declaring != null; declaring = declaring.getSuperclass()) {
            try {
                int modifiers = declaring.getDeclaredField(name).getModifiers();
                if (declaring == user || !Modifier.isPrivate((int)modifiers)) {
                    return true;
                }
            }
            catch (NotFoundException modifiers) {
                // empty catch block
            }
            try {
                continue;
            }
            catch (NotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public static void removeFinalModifer(CtClass ctClass, String field) {
        try {
            CtField f = ctClass.getDeclaredField(field);
            f.setModifiers(f.getModifiers() & 0xFFFFFFEF);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public static void makeFieldPublic(CtClass ctClass, String field) {
        try {
            CtField f = ctClass.getDeclaredField(field);
            f.setModifiers(Modifier.setPublic((int)f.getModifiers()));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public static void makeMethodSynthetic(CtMethod method) {
        int ACC_SYNTHETIC = 4096;
        method.setModifiers(method.getModifiers() | 0x1000);
    }

    public static void addLocalForParameter(CtMethod ctMethod, int param, String name) throws NotFoundException, CannotCompileException {
        CtClass type = ctMethod.getParameterTypes()[param - 1];
        ctMethod.addLocalVariable(name, type);
        ctMethod.insertBefore(name + " = $" + param + ";");
    }

    public static void addLocalForParameter(CtMethod ctMethod, String paramClass, String name) throws NotFoundException, CannotCompileException {
        for (int i = 0; i < ctMethod.getParameterTypes().length; ++i) {
            CtClass type = ctMethod.getParameterTypes()[i];
            if (!paramClass.equals(type.getName())) continue;
            JavassistUtil.addLocalForParameter(ctMethod, i + 1, name);
            return;
        }
        throw new NotFoundException("Param from class '" + paramClass + "'not found:");
    }

    public static void createMethodStopWatch(CtMethod method, String logPrefix, String stopWatchId) throws CannotCompileException, NotFoundException {
        if (!LoggerFactory.getLogger((String)logPrefix).isEnabled() || method == null) {
            return;
        }
        CtClass ctClass = method.getDeclaringClass();
        String methodName = "__" + method.getName();
        CtMethod newMethod = CtNewMethod.copy((CtMethod)method, (String)methodName, (CtClass)ctClass, null);
        newMethod.setModifiers(newMethod.getModifiers() & 0xFFFFFFFA | 2);
        ctClass.addMethod(newMethod);
        CtClass returnType = method.getReturnType();
        String returnLine = CtClass.voidType.equals(returnType) ? "" : "return";
        method.setBody("{  org.zeroturnaround.javarebel.StopWatch jrStopWatch =       org.zeroturnaround.javarebel.LoggerFactory.getLogger(\"" + logPrefix + "\").createStopWatch(\"" + stopWatchId + "\");  try {   " + returnLine + " " + methodName + "($$);  } finally {    jrStopWatch.stop();  }}");
    }

    public static boolean callsMethod(CtMethod ctMethod, final String calledMethodName) throws CannotCompileException {
        final boolean[] found = new boolean[]{false};
        ctMethod.instrument(new ExprEditor(){

            public void edit(MethodCall m) throws CannotCompileException {
                if (m.getMethodName().equals(calledMethodName)) {
                    found[0] = true;
                }
            }
        });
        return found[0];
    }

    public static void importUsedPackage(ClassPool cp, CtClass ctClass) {
        HashSet<String> allPackages = new HashSet<String>();
        Iterator it = cp.getImportedPackages();
        while (it.hasNext()) {
            allPackages.add((String)it.next());
        }
        allPackages.add(null);
        allPackages.add("");
        for (String referencedClass : ctClass.getRefClasses()) {
            String p;
            int lastDot;
            if (referencedClass.startsWith("java.") || (lastDot = referencedClass.lastIndexOf(46)) == -1 || !allPackages.add(p = referencedClass.substring(0, lastDot))) continue;
            cp.importPackage(p);
        }
    }

    public static void importSignatureUsedPackage(ClassPool cp, CtBehavior ctTarget) throws NotFoundException {
        HashSet<String> allPackages = new HashSet<String>();
        Iterator it = cp.getImportedPackages();
        while (it.hasNext()) {
            allPackages.add((String)it.next());
        }
        allPackages.add(null);
        allPackages.add("");
        for (CtClass referencedClass : ctTarget.getParameterTypes()) {
            if (!allPackages.add(referencedClass.getPackageName())) continue;
            cp.importPackage(referencedClass.getPackageName());
        }
        if (ctTarget instanceof CtMethod && allPackages.add(((CtMethod)ctTarget).getReturnType().getPackageName())) {
            cp.importPackage(((CtMethod)ctTarget).getReturnType().getPackageName());
        }
        for (CtClass exceptionType : ctTarget.getExceptionTypes()) {
            String exceptionName = exceptionType.getPackageName();
            if (!allPackages.add(exceptionName)) continue;
            cp.importPackage(exceptionName);
        }
    }

    public static String getReturnTypeFromSignature(String signature) {
        int l = signature.lastIndexOf(")L");
        return signature.substring(l + 2, signature.length() - 1).replace('/', '.');
    }

    public static List<String> getArgumentTypes(String methodDescriptor) {
        ArrayList<String> argumentTypes = new ArrayList<String>();
        int currentOffset = 1;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            int currentArgumentTypeOffset = currentOffset;
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
            }
            argumentTypes.add(methodDescriptor.substring(currentArgumentTypeOffset, currentOffset));
        }
        return argumentTypes;
    }

    private static class ValidatingMethodCallReplaceEditor
    extends ExprEditor {
        private final String methodName;
        private final String replaceStatement;
        private final int expectedMatchCount;
        private int matchCount = 0;

        public ValidatingMethodCallReplaceEditor(String methodName, String replaceStatement, int matchCount) {
            this.methodName = methodName;
            this.replaceStatement = replaceStatement;
            this.expectedMatchCount = matchCount;
        }

        public void edit(MethodCall m) throws CannotCompileException {
            if (m.getMethodName().equals(this.methodName)) {
                ++this.matchCount;
                m.replace(this.replaceStatement);
            }
        }

        public boolean doit(CtClass clazz, MethodInfo minfo) throws CannotCompileException {
            boolean result = super.doit(clazz, minfo);
            if (this.matchCount != this.expectedMatchCount) {
                throw new CannotCompileException("Expected " + this.expectedMatchCount + " method calls to " + this.methodName + " in " + clazz.getName() + "#" + minfo + ", found " + this.matchCount);
            }
            return result;
        }
    }

    public static class MethodCallReplaceEditor
    extends ExprEditor {
        private final String methodName;
        private final String replaceStatement;

        public MethodCallReplaceEditor(String methodName, String replaceStatement) {
            this.methodName = methodName;
            this.replaceStatement = replaceStatement;
        }

        public void edit(MethodCall m) throws CannotCompileException {
            if (m.getMethodName().equals(this.methodName)) {
                m.replace(this.replaceStatement);
            }
        }
    }
}

