/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;

public class LogMonitorHelper {
    private static Logger log = LoggerFactory.getLogger((String)"LogMonitor");
    private static String monitorRegex = null;

    public static boolean shouldMonitorLogMethod() {
        return monitorRegex != null;
    }

    public static void monitorLogMethod(Object o) {
        String s;
        if (o != null && (s = o.toString()).matches(monitorRegex)) {
            String message = "Output string '" + s + "' matched regex '" + monitorRegex + "', call stack: \n";
            StringBuilder sb = new StringBuilder(message);
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            for (int i = 2; i < stackTrace.length; ++i) {
                sb.append("\t").append(stackTrace[i]).append("\n");
            }
            log.info(sb.toString());
        }
    }

    static {
        String regexCandidate = ConfigurationFactory.getInstance().getProperty("rebel.log.monitor.regex");
        if (regexCandidate != null) {
            try {
                regexCandidate = regexCandidate.replaceAll("^\"|^'|\"$|'$", "");
                Pattern.compile(regexCandidate);
                monitorRegex = regexCandidate;
                log.info("Setup log monitor with regex pattern '{}'", (Object)monitorRegex);
            }
            catch (PatternSyntaxException e) {
                log.info("The supplied regex pattern '{}' was invalid", (Object)regexCandidate);
            }
        }
    }
}

