/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.SecurityController;

public class ReflectionUtil {
    public static <T> T invoke(Object target, String methodName, Object param1, Object param2, Object param3) {
        return (T)ReflectionUtil.invokeByArgs(target, methodName, param1, param2, param3);
    }

    public static <T> T invoke(Object target, String methodName, Object param1, Object param2) {
        return (T)ReflectionUtil.invokeByArgs(target, methodName, param1, param2);
    }

    public static <T> T invoke(Object target, String methodName, Object param1) {
        return (T)ReflectionUtil.invokeByArgs(target, methodName, param1);
    }

    public static <T> T invoke(Object target, String methodName) {
        return (T)ReflectionUtil.invokeByArgs(target, methodName, new Object[0]);
    }

    public static Object invokeByArgs(Object target, String methodName, Object ... args) {
        try {
            Method method = ReflectionUtil.findDeclaredMethod(target.getClass(), methodName, args);
            ReflectionUtil.setAccessible(method);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeStaticByArgs(Class<?> klass, String methodName, Object ... args) {
        try {
            Method method = ReflectionUtil.findDeclaredMethod(klass, methodName, args);
            ReflectionUtil.setAccessible(method);
            return method.invoke(null, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method findDeclaredMethod(Class<?> klass, String methodName, Object ... args) throws NoSuchMethodException {
        ArrayList<Method> result = new ArrayList<Method>();
        HashSet<String> nonPrivateSignatures = new HashSet<String>();
        for (Class<?> curr = klass; curr != null; curr = curr.getSuperclass()) {
            for (Method method : curr.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !ReflectionUtil.acceptsParameters(method, args) || !Modifier.isPrivate(method.getModifiers()) && !nonPrivateSignatures.add(ReflectionUtil.sig(method))) continue;
                result.add(method);
            }
        }
        if (result.size() > 1) {
            throw new NoSuchMethodException("ambiguous match: " + methodName + " on class " + klass.getName());
        }
        if (result.isEmpty()) {
            throw new NoSuchMethodException("no such method: " + methodName + " on class " + klass.getName());
        }
        return (Method)result.get(0);
    }

    private static String sig(Method method) {
        return method.getName() + MiscUtil.toString(method.getParameterTypes());
    }

    private static boolean acceptsParameters(Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (args[i] == null || parameterTypes[i].isInstance(args[i]) || ReflectionUtil.isBoxed(parameterTypes[i], args[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isBoxed(Class<?> expectedType, Object arg) {
        if (Boolean.TYPE.equals(expectedType)) {
            return arg instanceof Boolean;
        }
        if (Byte.TYPE.equals(expectedType)) {
            return arg instanceof Byte;
        }
        if (Character.TYPE.equals(expectedType)) {
            return arg instanceof Character;
        }
        if (Short.TYPE.equals(expectedType)) {
            return arg instanceof Short;
        }
        if (Integer.TYPE.equals(expectedType)) {
            return arg instanceof Integer;
        }
        if (Long.TYPE.equals(expectedType)) {
            return arg instanceof Long;
        }
        if (Float.TYPE.equals(expectedType)) {
            return arg instanceof Float;
        }
        if (Double.TYPE.equals(expectedType)) {
            return arg instanceof Double;
        }
        return false;
    }

    public static <T> T getFieldValue(Object o, String field) {
        try {
            return ReflectionUtil.getFieldValue(o.getClass(), o, field);
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"ReflectionUtil").error("Searching for " + MiscUtil.identityToString(o) + "." + field + " but got:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T getFieldValue(Class<?> orig, String field) {
        try {
            return ReflectionUtil.getFieldValue(orig, null, field);
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"ReflectionUtil").error("Searching for " + orig.getName() + "." + field + " but got:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static <T> T getFieldValue(Class<?> orig, Object o, String field) throws IllegalArgumentException, IllegalAccessException {
        for (Class<?> k = orig; k != null; k = k.getSuperclass()) {
            try {
                Field f = k.getDeclaredField(field);
                ReflectionUtil.setAccessible(f);
                return (T)f.get(o);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static void setFieldValue(Object instance, String field, Object value) {
        ReflectionUtil.setFieldValue(instance, instance.getClass(), field, value);
    }

    public static void setFieldValueOrFail(Object instance, String field, Object value) throws Exception {
        ReflectionUtil.setFieldValueOrFail(instance, instance.getClass(), field, value);
    }

    public static void setFieldValue(Object instance, Class<?> klass, String field, Object value) {
        try {
            ReflectionUtil.setFieldValueOrFail(instance, klass, field, value);
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"ReflectionUtil").error("Searching for " + MiscUtil.identityToString(instance) + "." + field + " but got:" + e.getMessage(), (Throwable)e);
        }
    }

    public static void setFieldValueOrFail(Object instance, Class<?> klass, String field, Object value) throws Exception {
        if (klass == null) {
            throw new IllegalArgumentException("klass == null");
        }
        NoSuchFieldException exception = null;
        while (klass != null) {
            try {
                Field f = klass.getDeclaredField(field);
                ReflectionUtil.setAccessible(f);
                f.set(instance, value);
                return;
            }
            catch (NoSuchFieldException e) {
                exception = e;
                klass = klass.getSuperclass();
            }
        }
        throw exception;
    }

    public static void setAccessible(final AccessibleObject m) {
        if (System.getSecurityManager() == null) {
            m.setAccessible(true);
        } else {
            SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    m.setAccessible(true);
                    return null;
                }
            });
        }
    }

    public static Field getDeclaredField(Class<?> klass, String name) {
        try {
            Field f = klass.getDeclaredField(name);
            ReflectionUtil.setAccessible(f);
            return f;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public static Method getDeclaredMethod(Class<?> klass, String method, Class<?> ... paramTypes) {
        try {
            Method m = klass.getDeclaredMethod(method, paramTypes);
            ReflectionUtil.setAccessible(m);
            return m;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static Constructor<?> getDeclaredConstructor(Class<?> klass, Class<?> ... paramTypes) {
        try {
            return klass.getDeclaredConstructor(paramTypes);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static Class<?> getClassForAnyName(ClassLoader loader, String ... names) {
        for (String name : names) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new RuntimeException("None of the following classes were found: " + Arrays.asList(names));
    }

    public static void copyDeclaredFields(Class<?> klass, Object src, Object dest) {
        Field[] fields;
        if (!klass.isInstance(src)) {
            throw new RuntimeException("src should be instance of klass");
        }
        if (!klass.isInstance(dest)) {
            throw new RuntimeException("dest should be instance of klass");
        }
        for (Field f : fields = klass.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers()) && !ReloaderFactory.getInstance().isReloadableClass(klass)) continue;
            ReflectionUtil.setAccessible(f);
            try {
                f.set(dest, f.get(src));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

