/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Reloader;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.integration.util.ClassReflectionUtil;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.ReflectionUtil;

public class ReloaderUtil {
    private static final Reloader reloader = ReloaderFactory.getInstance();
    private static final Method findLoadedClass = ReloaderUtil.getFindLoadedClass();

    public static void checkAndReload(Collection<Class<?>> classes) {
        if (classes == null) {
            return;
        }
        for (Class c : classes.toArray(new Class[0])) {
            reloader.checkAndReload(c);
        }
    }

    public static void checkAndReloadHierarchy(Class<?> clazz) {
        ReloaderUtil.checkAndReload(ClassReflectionUtil.getClassHierarchy(clazz));
    }

    public static boolean isReloadingAnyClass(Collection<Class<?>> classes) {
        return ReloaderUtil.isReloadingAnyClass(classes, null);
    }

    public static boolean isReloadingAnyClass(Collection<Class<?>> classes, Class<?> exclude) {
        if (classes == null) {
            return false;
        }
        for (Class klass : classes.toArray(new Class[0])) {
            if (exclude != null && exclude.equals(klass) || !reloader.isReloadingClass(klass)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsReloadableClass(Collection<Class<?>> classes) {
        if (classes == null) {
            return false;
        }
        for (Class<?> klass : classes) {
            if (!reloader.isReloadableClass(klass)) continue;
            return true;
        }
        return false;
    }

    public static Collection<Class<?>> getReloadableClasses(Collection<Class<?>> classes) {
        if (classes == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (Class<?> klass : classes) {
            if (!reloader.isReloadableClass(klass)) continue;
            result.add(klass);
        }
        return result;
    }

    private static Set<Class<?>> retainReloadableClasses(Set<Class<?>> classes) {
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            Class<?> klass = it.next();
            if (reloader.isReloadableClass(klass)) continue;
            it.remove();
        }
        return classes;
    }

    public static boolean isReloadableClassHierarchy(Class<?> klass) {
        return ReloaderUtil.containsReloadableClass(ClassReflectionUtil.getClassHierarchy(klass));
    }

    public static boolean existsReloadableClassHierarchy(Class<?>[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            Class<?> klass = classes[i];
            if (!ReloaderUtil.isReloadableClassHierarchy(klass)) continue;
            return true;
        }
        return false;
    }

    public static Set<Class<?>> getReloadableClassHierarchy(Class<?> klass) {
        return ReloaderUtil.retainReloadableClasses(ClassReflectionUtil.getClassHierarchy(klass));
    }

    public static Set<Class<?>> getReloadableClassHierarchies(Class<?>[] classes) {
        return ReloaderUtil.retainReloadableClasses(ClassReflectionUtil.getClassHierarchies(classes));
    }

    public static Set<Class<?>> getReloadableClassHierarchies(Collection<Class<?>> classes) {
        return ReloaderUtil.retainReloadableClasses(ClassReflectionUtil.getClassHierarchies(classes));
    }

    public static final Method getFindLoadedClass() {
        return ReflectionUtil.getDeclaredMethod(ClassLoader.class, "findLoadedClass", String.class);
    }

    public static final Class<?> getLoadedClass(ClassLoader cl, String name) {
        if (findLoadedClass == null) {
            return null;
        }
        try {
            return (Class)findLoadedClass.invoke((Object)cl, name);
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"Util").info("findLoadedClass for '" + name + "' failed on " + MiscUtil.identityToString(cl), (Throwable)e);
            return null;
        }
    }

    public static final boolean isLoadedClass(ClassLoader cl, String name) {
        return ReloaderUtil.getLoadedClass(cl, name) != null;
    }

    public static Set<Class<?>> withParentInterfaces(Class<?> klass) {
        Set<Class<?>> result = ClassReflectionUtil.getClassHierarchies(klass.getInterfaces());
        result.add(klass);
        ReloaderUtil.retainReloadableClasses(result);
        return result;
    }

    public static Set<Class<?>> withParentInterfaces(Collection<Class<?>> classes) {
        Set<Class<?>> result = ClassReflectionUtil.getClassHierarchies(ClassReflectionUtil.getInterfaces(classes));
        result.addAll(classes);
        ReloaderUtil.retainReloadableClasses(result);
        return result;
    }
}

