/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.Map;
import java.util.WeakHashMap;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.RebelServletContext;
import org.zeroturnaround.javarebel.RequestIntegration;
import org.zeroturnaround.javarebel.RequestIntegrationFactory;
import org.zeroturnaround.javarebel.RequestListener;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;

public class RequestCountingUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"RequestCountUtil");
    private static final RequestIntegration integration = RequestIntegrationFactory.getInstance();
    private static final Map<RebelServletContext, CountingRequestListener> listeners = new WeakHashMap<RebelServletContext, CountingRequestListener>();

    public static synchronized void register(RebelServletContext context) {
        CountingRequestListener listener = new CountingRequestListener();
        listeners.put(context, listener);
        integration.addRequestListener(context, (RequestListener)listener);
    }

    public static synchronized void unregister(RebelServletContext context) {
        CountingRequestListener listener = listeners.remove(context);
        if (listener != null) {
            integration.removeRequestListener(context, (RequestListener)listener);
        }
    }

    public static int countRunning(RebelServletContext context) {
        return RequestCountingUtil.get(context).counter();
    }

    public static boolean waitUntilNoRunning(RebelServletContext context, long timeout) throws InterruptedException {
        return RequestCountingUtil.get(context).waitForZero(timeout);
    }

    private static synchronized CountingRequestListener get(RebelServletContext context) {
        CountingRequestListener result = listeners.get(context);
        if (result == null) {
            throw new IllegalArgumentException("Unknown servlet context " + MiscUtil.identityToString(context));
        }
        return result;
    }

    private static class CountingRequestListener
    implements RequestListener {
        private volatile int counter;

        private CountingRequestListener() {
        }

        public boolean rawRequest(Object context, Object request, Object response) {
            return false;
        }

        public synchronized void beforeRequest() {
            ++this.counter;
        }

        public synchronized void requestFinally() {
            --this.counter;
            if (this.counter == 0) {
                this.notifyAll();
            }
        }

        public int priority() {
            return 0;
        }

        public synchronized int counter() {
            return this.counter;
        }

        public synchronized boolean waitForZero(long timeout) throws InterruptedException {
            if (this.counter == 0) {
                log.log("No running requests (did not wait).");
                return true;
            }
            log.log("Waiting until no running requests (current count: " + this.counter + ", timeout: " + timeout + " ms)...");
            long start = System.currentTimeMillis();
            long end = start + timeout;
            do {
                this.wait(end - System.currentTimeMillis());
                if (this.counter != 0) continue;
                long time = System.currentTimeMillis() - start;
                log.log("No running requests (waited for " + time + " ms).");
                return true;
            } while (System.currentTimeMillis() < end);
            log.log(this.counter + " requests still running (timeout reached).");
            return false;
        }
    }
}

