/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.lang.ref.WeakReference;
import org.zeroturnaround.javarebel.RequestIntegrationFactory;
import org.zeroturnaround.javarebel.RequestListener;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.WeakUtil;

public class RequestListenerUtil {
    public static RequestListener bindContextClassLoader(RequestListener listener) {
        return RequestListenerUtil.bindClassLoader(listener, MiscUtil.getContextClassLoader());
    }

    public static RequestListener bindClassLoader(RequestListener listener, ClassLoader cl) {
        if (!RequestListenerUtil.canSetTCL() || cl == null) {
            return WeakUtil.weak(listener);
        }
        return new BoundRequestListener(listener, cl);
    }

    private static boolean canSetTCL() {
        return !"com.evermind.server.ApplicationServerThread".equals(Thread.currentThread().getClass().getName());
    }

    private static class BoundRequestListener
    implements RequestListener,
    WeakUtil.RemovableListener {
        private final WeakReference<RequestListener> targetRef;
        private final WeakReference<ClassLoader> classLoderRef;
        private final String identity;
        private final int priority;

        public BoundRequestListener(RequestListener target, ClassLoader cl) {
            this.targetRef = new WeakUtil.WeakListenerReference<RequestListener>(this, target);
            this.classLoderRef = new WeakReference<ClassLoader>(cl);
            this.identity = "boundCL(" + MiscUtil.identityToString(cl) + ")[" + MiscUtil.dumpToString(target) + "]";
            this.priority = target.priority();
        }

        private ClassLoader getClassLoader() {
            return (ClassLoader)this.classLoderRef.get();
        }

        private RequestListener getTarget() {
            return (RequestListener)this.targetRef.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean rawRequest(Object context, Object request, Object response) throws Exception {
            RequestListener target = this.getTarget();
            if (target == null) {
                return false;
            }
            ClassLoader cl = this.getClassLoader();
            boolean hasCl = cl != null;
            ClassLoader old = hasCl ? MiscUtil.setContextClassLoader(cl) : null;
            try {
                boolean bl = target.rawRequest(context, request, response);
                return bl;
            }
            finally {
                if (hasCl) {
                    MiscUtil.setContextClassLoader(old);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeRequest() throws Exception {
            RequestListener target = this.getTarget();
            if (target == null) {
                return;
            }
            ClassLoader cl = this.getClassLoader();
            boolean hasCl = cl != null;
            ClassLoader old = hasCl ? MiscUtil.setContextClassLoader(cl) : null;
            try {
                target.beforeRequest();
            }
            finally {
                if (hasCl) {
                    MiscUtil.setContextClassLoader(old);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestFinally() throws Exception {
            RequestListener target = this.getTarget();
            if (target == null) {
                return;
            }
            ClassLoader cl = this.getClassLoader();
            boolean hasCl = cl != null;
            ClassLoader old = hasCl ? MiscUtil.setContextClassLoader(cl) : null;
            try {
                target.requestFinally();
            }
            finally {
                if (hasCl) {
                    MiscUtil.setContextClassLoader(old);
                }
            }
        }

        public int priority() {
            return this.priority;
        }

        public String toString() {
            return this.identity;
        }

        @Override
        public void remove() {
            RequestIntegrationFactory.getInstance().removeRequestListener((RequestListener)this);
        }
    }
}

