/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import org.zeroturnaround.javarebel.IntegrationFactory;

public class SecurityController {
    public static <T> T doWithoutSecurityManager(PrivilegedAction<T> action) {
        IntegrationFactory.getInstance().disableSecurityManager();
        try {
            T t = action.run();
            return t;
        }
        finally {
            IntegrationFactory.getInstance().enableSecurityManager();
        }
    }

    public static <T> T doWithoutSecurityManager(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        IntegrationFactory.getInstance().disableSecurityManager();
        try {
            T t = action.run();
            return t;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            IntegrationFactory.getInstance().enableSecurityManager();
        }
    }

    public static <T, X extends Exception> T doWithoutSecurityManager(PrivilegedDirectExceptionAction<T, X> action) throws X {
        IntegrationFactory.getInstance().disableSecurityManager();
        try {
            T t = action.run();
            return t;
        }
        finally {
            IntegrationFactory.getInstance().enableSecurityManager();
        }
    }

    public static interface PrivilegedAction<T> {
        public T run();
    }

    public static interface PrivilegedExceptionAction<T> {
        public T run() throws Exception;
    }

    public static class PrivilegedActionException
    extends Exception {
        private static final long serialVersionUID = 3772660879079290001L;

        public PrivilegedActionException(Exception exception) {
            super(exception);
        }
    }

    public static interface PrivilegedDirectExceptionAction<T, X extends Exception> {
        public T run() throws X;
    }
}

