/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.ClassEventListener;
import org.zeroturnaround.javarebel.ClassIdentityFilter;
import org.zeroturnaround.javarebel.ClassLoaderDestructionListener;
import org.zeroturnaround.javarebel.FileEventListener;
import org.zeroturnaround.javarebel.IntegrationFactory;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.RequestIntegrationFactory;
import org.zeroturnaround.javarebel.RequestListener;
import org.zeroturnaround.javarebel.ResourceIntegrationFactory;
import org.zeroturnaround.javarebel.integration.support.ClassBytecodeProcessorWrapper;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.SecurityController;
import org.zeroturnaround.javarebel.integration.util.WeakIdentityHashMap;

public class WeakUtil {
    public static <T> List<WeakReference<T>> createWeakReferenceList(Collection<T> elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<WeakReference<T>> result = new ArrayList<WeakReference<T>>();
        for (T object : elements) {
            if (object == null) continue;
            result.add(new WeakReference<T>(object));
        }
        return result;
    }

    public static <T> Set<T> createWeakHashSet() {
        return WeakUtil.createWeakHashSetInternal(null);
    }

    public static <T> Set<T> createWeakIdentityHashSet() {
        return WeakUtil.createWeakHashSetInternal(new WeakIdentityHashMap(), null);
    }

    public static <T> Set<T> createWeakHashSet(Collection<T> elements) {
        if (elements == null) {
            return null;
        }
        return WeakUtil.createWeakHashSetInternal(elements);
    }

    private static <T> Set<T> createWeakHashSetInternal(Collection<T> elements) {
        return WeakUtil.createWeakHashSetInternal(new WeakHashMap(), elements);
    }

    private static <T> Set<T> createWeakHashSetInternal(Map<T, Boolean> map, Collection<T> elements) {
        Set<T> result = Collections.newSetFromMap(map);
        if (elements != null) {
            result.addAll(elements);
        }
        return result;
    }

    public static ClassBytecodeProcessor weakCBP(ClassBytecodeProcessor cbp) {
        return WeakUtil.weak(cbp);
    }

    public static ClassBytecodeProcessor weak(ClassBytecodeProcessor cbp) {
        return new WeakClassBytecodeProcessorAdapter(cbp);
    }

    public static ClassEventListener weakCEL(ClassEventListener cel) {
        return WeakUtil.weak(cel);
    }

    public static ClassEventListener weak(ClassEventListener cel) {
        return new WeakClassEventListenerAdapter(cel);
    }

    public static ClassLoaderDestructionListener weakCDL(ClassLoaderDestructionListener cdl) {
        return WeakUtil.weak(cdl);
    }

    public static ClassLoaderDestructionListener weak(ClassLoaderDestructionListener cdl) {
        return new WeakClassLoaderDestructionListener(cdl);
    }

    public static ClassIdentityFilter weakCIF(ClassIdentityFilter cif) {
        return WeakUtil.weak(cif);
    }

    public static ClassIdentityFilter weak(ClassIdentityFilter cif) {
        return new WeakClassIdentityFilterAdapter(cif);
    }

    public static RequestListener weak(RequestListener listener) {
        return new WeakRequestListener(listener);
    }

    public static RequestListener weakRL(RequestListener listener) {
        return WeakUtil.weak(listener);
    }

    public static FileEventListener weak(FileEventListener listener) {
        return new WeakFileEventListener(listener);
    }

    private static class WeakClassBytecodeProcessorAdapter
    implements ClassBytecodeProcessor,
    RemovableListener,
    ClassBytecodeProcessorWrapper {
        private final WeakReference<ClassBytecodeProcessor> cbp;
        private final int priority;
        private final String identity;

        public WeakClassBytecodeProcessorAdapter(ClassBytecodeProcessor cbp) {
            this.cbp = new WeakListenerReference<ClassBytecodeProcessor>(this, cbp);
            this.identity = MiscUtil.identityToString(this) + "[" + MiscUtil.dumpToString(cbp) + "]";
            this.priority = this.getPriority(cbp);
        }

        private int getPriority(ClassBytecodeProcessor cbp) {
            try {
                return cbp.priority();
            }
            catch (AbstractMethodError e) {
                return 0;
            }
        }

        public byte[] process(ClassLoader cl, String classname, byte[] bytecode) {
            ClassBytecodeProcessor delegate = (ClassBytecodeProcessor)this.cbp.get();
            if (delegate == null) {
                this.remove();
                return bytecode;
            }
            return delegate.process(cl, classname, bytecode);
        }

        public String toString() {
            return this.identity;
        }

        @Override
        public void remove() {
            IntegrationFactory.getInstance().removeIntegrationProcessor((ClassBytecodeProcessor)this);
        }

        @Override
        public ClassBytecodeProcessor getDelegate() {
            return (ClassBytecodeProcessor)this.cbp.get();
        }

        public int priority() {
            return this.priority;
        }
    }

    private static class WeakClassEventListenerAdapter
    implements ClassEventListener,
    RemovableListener {
        private final WeakReference<ClassEventListener> cel;
        private final int priority;
        private final String identity;

        public WeakClassEventListenerAdapter(ClassEventListener cel) {
            this.cel = new WeakListenerReference<ClassEventListener>(this, cel);
            this.priority = cel.priority();
            this.identity = "weak[" + MiscUtil.dumpToString(cel) + "]";
        }

        public void onClassEvent(int eventType, Class<?> klass, Collection<ClassEventListener.ChangeType> changeTypes) throws Exception {
            ClassEventListener delegate = (ClassEventListener)this.cel.get();
            if (delegate == null) {
                this.remove();
                return;
            }
            delegate.onClassEvent(eventType, klass, changeTypes);
        }

        public int priority() {
            return this.priority;
        }

        public String toString() {
            return this.identity;
        }

        @Override
        public void remove() {
            ReloaderFactory.getInstance().removeClassReloadListener((ClassEventListener)this);
        }
    }

    private static class WeakClassLoaderDestructionListener
    implements ClassLoaderDestructionListener,
    RemovableListener {
        private final WeakReference<ClassLoaderDestructionListener> cdl;
        private final String identity;

        public WeakClassLoaderDestructionListener(ClassLoaderDestructionListener cdl) {
            this.cdl = new WeakListenerReference<ClassLoaderDestructionListener>(this, cdl);
            this.identity = MiscUtil.identityToString(cdl);
        }

        public void onDestroy(ClassLoader cl) {
            ClassLoaderDestructionListener delegate = (ClassLoaderDestructionListener)this.cdl.get();
            if (delegate == null) {
                this.remove();
                return;
            }
            delegate.onDestroy(cl);
        }

        public String toString() {
            return this.identity;
        }

        @Override
        public void remove() {
            IntegrationFactory.getInstance().removeClassLoaderDestructionListener((ClassLoaderDestructionListener)this);
        }
    }

    private static class WeakClassIdentityFilterAdapter
    implements ClassIdentityFilter {
        private final WeakReference<ClassIdentityFilter> cbp;
        private final String identity;

        public WeakClassIdentityFilterAdapter(ClassIdentityFilter cbp) {
            this.cbp = new WeakReference<ClassIdentityFilter>(cbp);
            this.identity = MiscUtil.identityToString(cbp);
        }

        public boolean matches(ClassLoader cl, String className) {
            ClassIdentityFilter delegate = (ClassIdentityFilter)this.cbp.get();
            if (delegate == null) {
                return false;
            }
            return delegate.matches(cl, className);
        }

        public String toString() {
            return this.identity;
        }
    }

    private static class WeakRequestListener
    implements RequestListener,
    RemovableListener {
        private final WeakReference<RequestListener> ref;
        private final String identity;
        private final int priority;

        public WeakRequestListener(RequestListener target) {
            this.ref = new WeakListenerReference<RequestListener>(this, target);
            this.identity = "weak[" + MiscUtil.dumpToString(target) + "]";
            this.priority = target.priority();
        }

        public boolean rawRequest(Object context, Object request, Object response) throws Exception {
            RequestListener target = (RequestListener)this.ref.get();
            if (target != null) {
                return target.rawRequest(context, request, response);
            }
            this.remove();
            return false;
        }

        public void beforeRequest() throws Exception {
            RequestListener target = (RequestListener)this.ref.get();
            if (target != null) {
                target.beforeRequest();
            }
        }

        public void requestFinally() throws Exception {
            RequestListener target = (RequestListener)this.ref.get();
            if (target != null) {
                target.requestFinally();
            }
        }

        public String toString() {
            return this.identity;
        }

        @Override
        public void remove() {
            RequestIntegrationFactory.getInstance().removeRequestListener((RequestListener)this);
        }

        public int priority() {
            return this.priority;
        }
    }

    private static class WeakFileEventListener
    implements FileEventListener,
    RemovableListener {
        private final WeakReference<FileEventListener> ref;
        private final String identity;

        public WeakFileEventListener(FileEventListener target) {
            this.ref = new WeakListenerReference<FileEventListener>(this, target);
            this.identity = MiscUtil.identityToString(this) + "[" + MiscUtil.dumpToString(target) + "]";
        }

        private FileEventListener get() {
            FileEventListener target = (FileEventListener)this.ref.get();
            if (target == null) {
                this.remove();
            }
            return target;
        }

        public boolean isRecursive() {
            FileEventListener target = this.get();
            if (target != null) {
                return target.isRecursive();
            }
            return false;
        }

        public void onFileAdd(File file) {
            FileEventListener target = this.get();
            if (target != null) {
                target.onFileAdd(file);
            }
        }

        public void onFileChange(File file) {
            FileEventListener target = this.get();
            if (target != null) {
                target.onFileChange(file);
            }
        }

        public void onFileRemove(File file) {
            FileEventListener target = this.get();
            if (target != null) {
                target.onFileRemove(file);
            }
        }

        public void onFileDirty(File file) {
            FileEventListener target = this.get();
            if (target != null) {
                target.onFileDirty(file);
            }
        }

        public void onFailure() {
            FileEventListener target = this.get();
            if (target != null) {
                target.onFailure();
            }
        }

        public String toString() {
            return this.identity;
        }

        @Override
        public void remove() {
            ResourceIntegrationFactory.getInstance().removeFileListener((FileEventListener)this);
        }
    }

    public static class WeakListenerReference<T>
    extends WeakReference<T> {
        private static final ReferenceQueue<Object> rq = new ReferenceQueue();
        private final RemovableListener owner;

        public WeakListenerReference(RemovableListener owner, T target) {
            super(target, rq);
            this.owner = owner;
        }

        static {
            final Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            WeakListenerReference ref = (WeakListenerReference)rq.remove();
                            ref.owner.remove();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            };
            SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread t = new Thread(r, "rebel-weak-reaper");
                    t.setDaemon(true);
                    t.setContextClassLoader(null);
                    t.start();
                    return null;
                }
            });
        }
    }

    public static interface RemovableListener {
        public void remove();
    }
}

