/**
 * Copyright (C) 2013 ZeroTurnaround OU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License v2 as published by
 * the Free Software Foundation, with the additional requirement that
 * ZeroTurnaround OU must be prominently attributed in the program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of GNU General Public License v2 from
 *   http://www.gnu.org/licenses/gpl-2.0.txt
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import java.io.File;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.LiferayPlugin;

/**
 * Added to <code>com.liferay.portal.kernel.util.FileUtil</code>.
 * Debug for Liferay file overwriting
 * 
 * @author Andres Luuk
 */
public class FileUtilCBP extends CacheAwareJavassistClassBytecodeProcessor {

  public void process(final ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("org.zeroturnaround.javarebel");
    cp.importPackage("org.zeroturnaround.javarebel.integration.util");

    ctClass.addField(CtField.make("private static final Logger jrLogger = LoggerFactory.getInstance().productPrefix(\"" + LiferayPlugin.PRODUCT_PREFIX + "\");", ctClass));

    CtClass[] argTypes = cp.get(new String[] { File.class.getName(), File.class.getName() });
    ctClass.getDeclaredMethod("copyFile", argTypes).insertBefore("" +
        "jrLogger.trace(\"copy file: \" + $1 + \" -> \" + $2);");
    ctClass.getDeclaredMethod("copyDirectory", argTypes).insertBefore("" +
        "jrLogger.trace(\"copy dir: \" + $1 + \" -> \" + $2);");
  }

}
