package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.util.JavassistUtil;

public class IPGeocoderImplCBP extends CacheAwareJavassistClassBytecodeProcessor {

  @Override
  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    if (!JavassistUtil.hasDeclaredMethod(ctClass, "write")) {
      // method was removed somewhere between 7.4.3.36 and 7.4.3.42
      return;
    }
    CtMethod write = ctClass.getDeclaredMethod("write");

    copyFileUsingBuffer(cp, write);
  }

  private void copyFileUsingBuffer(ClassPool cp, CtMethod write) throws CannotCompileException, NotFoundException {
    write.addLocalVariable("buffer", cp.get(byte[].class.getName()));
    write.insertBefore("buffer = new byte[4096];");

    write.instrument(new ExprEditor() {
      @Override
      public void edit(MethodCall m) throws CannotCompileException {
        if ("read".equals(m.getMethodName())) {
          m.replace("" +
              "{" +
              "  $_ = $0.read(buffer, 0, 4096);" +
              "}");
        }
        else if ("write".equals(m.getMethodName())) {
          m.replace("" +
              "{" +
              "  $0.write(buffer, 0, $1);" +
              "}");
        }
      }
    });
  }
}
