/**
 * Copyright (C) 2011 ZeroTurnaround OU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License v2 as published by
 * the Free Software Foundation, with the additional requirement that
 * ZeroTurnaround OU must be prominently attributed in the program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of GNU General Public License v2 from
 *   http://www.gnu.org/licenses/gpl-2.0.txt
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.util.ClassLoaderResourceInputStream;

/**
 * Allows to deploy one portlet with old instance again
 *
 * @author Andres Luuk
 */
public class PortletBagFactoryCBP extends CacheAwareJavassistClassBytecodeProcessor {

  public void process(final ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("com.liferay.portal.kernel.portlet");
    cp.importPackage("org.zeroturnaround.jrebel.liferay.util");

    for (CtMethod m : ctClass.getDeclaredMethods("create")) {
      m.instrument(new ExprEditor() {
        public void edit(MethodCall m) throws CannotCompileException {
          if ("newConfigurationAction".equals(m.getMethodName()) || "newConfigurationActions".equals(m.getMethodName())) {
            m.replace("" +
                "{" +
                "  PortletBag portletBag = PortletBagPool.get(portlet.getRootPortletId());" +
                "  if (portletBag!= null){ " +
                "    portletInstance = portletBag.getPortletInstance(); " +
                "  }" +
                "  $_ = $proceed($$);" +
                "}");
          }
        }
      });
    }

    try {
      ctClass.getDeclaredMethod("getResourceBundleInputStream").instrument(new ExprEditor() {
        @Override
        public void edit(MethodCall m) throws CannotCompileException {
          if ("getResourceAsStream".equals(m.getMethodName())) {
            m.replace(
                "$_ = $proceed($$);" +
                "if ($_ != null) { " +
                "  $_ = ($r) new " + ClassLoaderResourceInputStream.class.getName() + "($_, _classLoader, $1);" +
                "}"
            );
          }
        }
      });
    } catch (NotFoundException e) {
      // liferay 6.0 or older?
    }

  }
}
