package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.util.JavassistUtil;

public class RubyExecutorCBP extends CacheAwareJavassistClassBytecodeProcessor {
  @Override
  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("org.zeroturnaround.javarebel");

    ctClass.addField(CtField.make("" +
        "private static final Logger log = LoggerFactory.getLogger(\"Liferay\");", ctClass));

    if (JavassistUtil.hasDeclaredMethod(ctClass, "doEval")) {
      addTimer(ctClass, "doEval");
    }
    else {
      addTimer(ctClass, "eval");
    }
  }

  private void addTimer(CtClass ctClass, String name) throws NotFoundException, CannotCompileException {
    CtMethod ctMethod = ctClass.getDeclaredMethod(name);
    String copyName = "__" + ctMethod.getName();
    ctClass.addMethod(CtNewMethod.copy(ctMethod, copyName, ctClass, null));
    ctMethod.setBody("" +
        "{" +
        "  StopWatch sw = log.createStopWatch(\"Liferay#runScriptlet\");" +
        "  try {" +
        "    return " + copyName + "($$);" +
        "  } finally {" +
        "    sw.stop();" +
        "  }" +
        "}");
  }
}
