package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.util.JavassistUtil;

/**
 * Fix leaking stream in liferays 6.2.0 and 6.2.1. This is already fixed in Liferay 6.2.2+, where they use TimestampUtil instead.
 */
public class ServletContextUtilCBP extends CacheAwareJavassistClassBytecodeProcessor {
  @Override
  public void process(ClassPool cp, ClassLoader classLoader, CtClass ctClass) throws Exception {
    CtMethod m = JavassistUtil.getDeclaredMethod(ctClass, "getLastModified", "javax.servlet.ServletContext", "java.lang.String", Boolean.TYPE.getName());
    if (m == null) {
      return;
    }
    cp.importPackage("java.net");
    cp.importPackage("java.io");

    ctClass.addMethod(CtNewMethod.make(
        "private static long getLastModifiedAndClose(URLConnection conn) {" +
        "  InputStream stream = null;" +
        "  try {" +
        "    long last = conn.getLastModified();" +
        "    stream = conn.getInputStream();" +
        "    return last;" +
        "  } finally {" +
        "    try {" +
        "      if (stream != null) { " +
        "        stream.close(); " +
        "      }" +
        "    } catch (IOException ex) {" +
        "    }" +
        "  }" +
        "}",
        ctClass)
    );

    m.addLocalVariable("_lastMod", cp.get(Long.TYPE.getName()));
//    m.insertBefore("_lastMod = 0L;");
    m.instrument(new ExprEditor() {
      @Override
      public void edit(MethodCall mCall) throws CannotCompileException {
        if (mCall.getMethodName().equals("openConnection")) {
          mCall.replace(
              "$_ = $proceed($$);" +
              "_lastMod = getLastModifiedAndClose($_);"
          );
        }

        // We can't call getLastModified, because we already closed the stream, return the cached value instead.
        else if ("java.net.URLConnection".equals(mCall.getClassName()) && mCall.getMethodName().equals("getLastModified")) {
          mCall.replace("$_ = _lastMod;");
        }
      }
    });
  }


}
